/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.Queue;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;

public class ActiveMQQueue
extends ActiveMQDestination
implements Queue {
    private static final long serialVersionUID = -1106092883162295462L;

    public ActiveMQQueue() {
        this((SimpleString)null);
    }

    public ActiveMQQueue(String address) {
        super(address, ActiveMQDestination.TYPE.QUEUE, null);
    }

    public ActiveMQQueue(SimpleString address) {
        super(address, ActiveMQDestination.TYPE.QUEUE, null);
    }

    @Deprecated
    public ActiveMQQueue(String address, String name) {
        super(address, name, ActiveMQDestination.TYPE.QUEUE, null);
    }

    public ActiveMQQueue(String address, boolean temporary) {
        super(address, temporary ? ActiveMQDestination.TYPE.TEMP_QUEUE : ActiveMQDestination.TYPE.QUEUE, null);
    }

    public ActiveMQQueue(String address, boolean temporary, ActiveMQSession session) {
        super(address, temporary ? ActiveMQDestination.TYPE.TEMP_QUEUE : ActiveMQDestination.TYPE.QUEUE, session);
    }

    public String getQueueName() {
        return this.getName();
    }

    @Override
    public String toString() {
        return "ActiveMQQueue[" + this.getAddress() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQQueue)) {
            return false;
        }
        ActiveMQQueue that = (ActiveMQQueue)o;
        return super.getAddress().equals(that.getAddress());
    }

    @Override
    public int hashCode() {
        return super.getAddress().hashCode();
    }
}

