/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mime4j;

import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.jmap.mime4j.FakeBinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.FieldName;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

public class SizeUtils {
    public static long sizeOf(Entity entity) throws IOException {
        if (entity instanceof BodyPart) {
            BodyPart bodyPart = (BodyPart)entity;
            return SizeUtils.sizeOf(bodyPart.getBody());
        }
        if (entity instanceof MessageImpl) {
            MessageImpl bodyPart = (MessageImpl)entity;
            return SizeUtils.sizeOf(bodyPart.getBody());
        }
        CountingOutputStream countingOutputStream = new CountingOutputStream(OutputStream.nullOutputStream());
        DefaultMessageWriter defaultMessageWriter = new DefaultMessageWriter();
        defaultMessageWriter.writeEntity(entity, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }

    public static long sizeOf(Header header) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(OutputStream.nullOutputStream());
        DefaultMessageWriter defaultMessageWriter = new DefaultMessageWriter();
        defaultMessageWriter.writeHeader(header, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }

    public static long sizeOf(Body body) throws IOException {
        if (body instanceof FakeBinaryBody) {
            return ((FakeBinaryBody)body).getSize();
        }
        if (body instanceof SingleBody) {
            return ((SingleBody)body).size();
        }
        if (body instanceof Multipart) {
            return SizeUtils.sizeOfMultipart((Multipart)body);
        }
        if (body instanceof Message) {
            Message message = (Message)body;
            return SizeUtils.sizeOf(message.getHeader()) + SizeUtils.sizeOf(message.getBody());
        }
        CountingOutputStream countingOutputStream = new CountingOutputStream(OutputStream.nullOutputStream());
        DefaultMessageWriter defaultMessageWriter = new DefaultMessageWriter();
        defaultMessageWriter.writeBody(body, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }

    public static long sizeOfMultipart(Multipart multipart) throws IOException {
        ByteSequence epilogue;
        ByteSequence preamble;
        long result = 0L;
        ContentTypeField contentType = SizeUtils.getContentType(multipart);
        ByteSequence boundary = SizeUtils.getBoundary(contentType);
        if (multipart instanceof MultipartImpl) {
            preamble = ((MultipartImpl)multipart).getPreambleRaw();
            epilogue = ((MultipartImpl)multipart).getEpilogueRaw();
        } else {
            preamble = multipart.getPreamble() != null ? ContentUtil.encode((CharSequence)multipart.getPreamble()) : null;
            ByteSequence byteSequence = epilogue = multipart.getEpilogue() != null ? ContentUtil.encode((CharSequence)multipart.getEpilogue()) : null;
        }
        if (preamble != null) {
            result += (long)(preamble.length() + 2);
        }
        for (Entity bodyPart : multipart.getBodyParts()) {
            result += (long)(2 + boundary.length() + 2);
            result += SizeUtils.sizeOf(bodyPart.getHeader());
            result += SizeUtils.sizeOf(bodyPart);
            result += 2L;
        }
        result += (long)(2 + boundary.length() + 2 + 2);
        if (epilogue != null) {
            result += (long)epilogue.length();
        }
        return result;
    }

    private static ContentTypeField getContentType(Multipart multipart) {
        Entity parent = multipart.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Missing parent entity in multipart");
        }
        Header header = parent.getHeader();
        if (header == null) {
            throw new IllegalArgumentException("Missing header in parent entity");
        }
        ContentTypeField contentType = (ContentTypeField)header.getField(FieldName.CONTENT_TYPE_LOWERCASE);
        if (contentType == null) {
            throw new IllegalArgumentException("Content-Type field not specified");
        }
        return contentType;
    }

    private static ByteSequence getBoundary(ContentTypeField contentType) {
        String boundary = contentType.getBoundary();
        if (boundary == null) {
            throw new IllegalArgumentException("Multipart boundary not specified. Mime-Type: " + contentType.getMimeType() + ", Raw: " + contentType.toString());
        }
        return ContentUtil.encode((CharSequence)boundary);
    }
}

