/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class ExtendedRequest
extends LDAPRequest
implements ResponseAcceptor,
ProtocolOp {
    protected static final byte TYPE_EXTENDED_REQUEST_OID = -128;
    protected static final byte TYPE_EXTENDED_REQUEST_VALUE = -127;
    private static final long serialVersionUID = 5572410770060685796L;
    @Nullable
    private final ASN1OctetString value;
    private int messageID = -1;
    @NotNull
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    @NotNull
    private final String oid;

    public ExtendedRequest(@NotNull String oid) {
        super(null);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = null;
    }

    public ExtendedRequest(@NotNull String oid, @Nullable Control[] controls) {
        super(controls);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = null;
    }

    public ExtendedRequest(@NotNull String oid, @Nullable ASN1OctetString value) {
        super(null);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = value;
    }

    public ExtendedRequest(@NotNull String oid, @Nullable ASN1OctetString value, @Nullable Control[] controls) {
        super(controls);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = value;
    }

    protected ExtendedRequest(@NotNull ExtendedRequest extendedRequest) {
        super(extendedRequest.getControls());
        this.messageID = extendedRequest.messageID;
        this.oid = extendedRequest.oid;
        this.value = extendedRequest.value;
    }

    @NotNull
    public final String getOID() {
        return this.oid;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    @Nullable
    public final ASN1OctetString getValue() {
        return this.value;
    }

    @Override
    public final byte getProtocolOpType() {
        return 119;
    }

    @Override
    public final void writeTo(@NotNull ASN1Buffer writer) {
        ASN1BufferSequence requestSequence = writer.beginSequence((byte)119);
        writer.addOctetString((byte)-128, this.oid);
        if (this.value != null) {
            writer.addOctetString((byte)-127, this.value.getValue());
        }
        requestSequence.end();
    }

    @Override
    @NotNull
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] protocolOpElements = this.value == null ? new ASN1Element[]{new ASN1OctetString(-128, this.oid)} : new ASN1Element[]{new ASN1OctetString(-128, this.oid), new ASN1OctetString(-127, this.value.getValue())};
        return new ASN1Sequence(119, protocolOpElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected ExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        this.setReferralDepth(depth);
        if (connection.synchronousMode()) {
            return this.processSync(connection);
        }
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        connection.registerResponseAcceptor(this.messageID, this);
        try {
            LDAPResponse response;
            long responseTimeout = this.getResponseTimeoutMillis(connection);
            Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
            LDAPConnectionLogger logger = connection.getConnectionOptions().getConnectionLogger();
            if (logger != null) {
                logger.logExtendedRequest(connection, this.messageID, this);
            }
            long requestTime = System.nanoTime();
            connection.getConnectionStatistics().incrementNumExtendedRequests();
            if (this instanceof StartTLSExtendedRequest) {
                connection.sendMessage(message, 50L);
            } else {
                connection.sendMessage(message, responseTimeout);
            }
            try {
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXTOP_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            ExtendedResult extendedResult = this.handleResponse(connection, response, requestTime);
            return extendedResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    @NotNull
    private ExtendedResult processSync(@NotNull LDAPConnection connection) throws LDAPException {
        LDAPResponse response;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
        LDAPConnectionLogger logger = connection.getConnectionOptions().getConnectionLogger();
        if (logger != null) {
            logger.logExtendedRequest(connection, this.messageID, this);
        }
        connection.getConnectionStatistics().incrementNumExtendedRequests();
        connection.sendMessage(message, this.getResponseTimeoutMillis(connection));
        while (true) {
            try {
                response = connection.readResponse(this.messageID);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (le.getResultCode() == ResultCode.TIMEOUT && connection.getConnectionOptions().abandonOnTimeout()) {
                    connection.abandon(this.messageID, new Control[0]);
                }
                throw le;
            }
            if (!(response instanceof IntermediateResponse)) break;
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime);
    }

    @NotNull
    private ExtendedResult handleResponse(@NotNull LDAPConnection connection, @Nullable LDAPResponse response, long requestTime) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            if (connection.getConnectionOptions().abandonOnTimeout()) {
                connection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_EXTENDED_CLIENT_TIMEOUT.get(waitTime, this.messageID, this.oid, connection.getHostPort()));
        }
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String msg = ccr.getMessage();
            if (msg == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), msg));
        }
        connection.getConnectionStatistics().incrementNumExtendedResponses(System.nanoTime() - requestTime);
        return (ExtendedResult)response;
    }

    @Override
    @InternalUseOnly
    public final void responseReceived(@NotNull LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public final int getLastMessageID() {
        return this.messageID;
    }

    @Override
    @NotNull
    public final OperationType getOperationType() {
        return OperationType.EXTENDED;
    }

    @Override
    @NotNull
    public ExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public ExtendedRequest duplicate(@Nullable Control[] controls) {
        ExtendedRequest r = new ExtendedRequest(this.oid, this.value, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @NotNull
    public String getExtendedRequestName() {
        return this.oid;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ExtendedRequest(oid='");
        buffer.append(this.oid);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(3);
        constructorArgs.add(ToCodeArgHelper.createString(this.oid, "Request OID"));
        constructorArgs.add(ToCodeArgHelper.createASN1OctetString(this.value, "Request Value"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Request Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "ExtendedRequest", requestID + "Request", "new ExtendedRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  ExtendedResult " + requestID + "Result = connection.processExtendedOperation(" + requestID + "Request);");
            lineList.add(indent + "  // The extended operation was processed and we have a result.");
            lineList.add(indent + "  // This does not necessarily mean that the operation was successful.");
            lineList.add(indent + "  // Examine the result details for more information.");
            lineList.add(indent + "  ResultCode resultCode = " + requestID + "Result.getResultCode();");
            lineList.add(indent + "  String message = " + requestID + "Result.getMessage();");
            lineList.add(indent + "  String matchedDN = " + requestID + "Result.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = " + requestID + "Result.getReferralURLs();");
            lineList.add(indent + "  String responseOID = " + requestID + "Result.getOID();");
            lineList.add(indent + "  ASN1OctetString responseValue = " + requestID + "Result.getValue();");
            lineList.add(indent + "  Control[] responseControls = " + requestID + "Result.getResponseControls();");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // A problem was encountered while attempting to process the extended operation.");
            lineList.add(indent + "  // Maybe the following will help explain why.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

