/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.remote.delivery.Bouncer;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MailetUtil;

public class RemoteDeliveryFailedWithSMTPCode
extends GenericMatcher {
    private Integer errorCode;

    public void init() throws MessagingException {
        this.errorCode = MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)this.getCondition());
        Preconditions.checkArgument((this.errorCode >= 101 && this.errorCode <= 554 ? 1 : 0) != 0, (Object)"Invalid SMTP code");
    }

    public Collection<MailAddress> match(Mail mail) {
        return AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)Bouncer.DELIVERY_ERROR_CODE, Integer.class).filter(this.errorCode::equals).map(any -> mail.getRecipients()).orElse((Collection)ImmutableList.of());
    }
}

