/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableAddColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableDropColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableRenameColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableWithOptionsEnd;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.internal.querybuilder.schema.Utils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultAlterTable
implements AlterTableStart,
AlterTableAddColumnEnd,
AlterTableDropColumnEnd,
AlterTableRenameColumnEnd,
AlterTableWithOptionsEnd,
BuildableQuery {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier tableName;
    private final ImmutableMap<CqlIdentifier, DataType> allColumnsToAddInOrder;
    private final ImmutableSet<CqlIdentifier> columnsToAddRegular;
    private final ImmutableSet<CqlIdentifier> columnsToAddStatic;
    private final ImmutableSet<CqlIdentifier> columnsToDrop;
    private final ImmutableMap<CqlIdentifier, CqlIdentifier> columnsToRename;
    private final CqlIdentifier columnToAlter;
    private final DataType columnToAlterType;
    private final ImmutableMap<String, Object> options;
    private final boolean dropCompactStorage;

    public DefaultAlterTable(@NonNull CqlIdentifier tableName) {
        this(null, tableName);
    }

    public DefaultAlterTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        this(keyspace, tableName, false, (ImmutableMap<CqlIdentifier, DataType>)ImmutableMap.of(), (ImmutableSet<CqlIdentifier>)ImmutableSet.of(), (ImmutableSet<CqlIdentifier>)ImmutableSet.of(), (ImmutableSet<CqlIdentifier>)ImmutableSet.of(), (ImmutableMap<CqlIdentifier, CqlIdentifier>)ImmutableMap.of(), null, null, (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public DefaultAlterTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName, boolean dropCompactStorage, @NonNull ImmutableMap<CqlIdentifier, DataType> allColumnsToAddInOrder, @NonNull ImmutableSet<CqlIdentifier> columnsToAddRegular, @NonNull ImmutableSet<CqlIdentifier> columnsToAddStatic, @NonNull ImmutableSet<CqlIdentifier> columnsToDrop, @NonNull ImmutableMap<CqlIdentifier, CqlIdentifier> columnsToRename, @Nullable CqlIdentifier columnToAlter, @Nullable DataType columnToAlterType, @NonNull ImmutableMap<String, Object> options) {
        this.keyspace = keyspace;
        this.tableName = tableName;
        this.dropCompactStorage = dropCompactStorage;
        this.allColumnsToAddInOrder = allColumnsToAddInOrder;
        this.columnsToAddRegular = columnsToAddRegular;
        this.columnsToAddStatic = columnsToAddStatic;
        this.columnsToDrop = columnsToDrop;
        this.columnsToRename = columnsToRename;
        this.columnToAlter = columnToAlter;
        this.columnToAlterType = columnToAlterType;
        this.options = options;
    }

    @Override
    @NonNull
    public AlterTableAddColumnEnd addColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultAlterTable(this.keyspace, this.tableName, this.dropCompactStorage, ImmutableCollections.append(this.allColumnsToAddInOrder, columnName, dataType), Utils.appendSet(this.columnsToAddRegular, columnName), this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.options);
    }

    @Override
    @NonNull
    public AlterTableAddColumnEnd addStaticColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultAlterTable(this.keyspace, this.tableName, this.dropCompactStorage, ImmutableCollections.append(this.allColumnsToAddInOrder, columnName, dataType), this.columnsToAddRegular, Utils.appendSet(this.columnsToAddStatic, columnName), this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.options);
    }

    @Override
    @NonNull
    public BuildableQuery dropCompactStorage() {
        return new DefaultAlterTable(this.keyspace, this.tableName, true, this.allColumnsToAddInOrder, this.columnsToAddRegular, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.options);
    }

    @Override
    @NonNull
    public AlterTableDropColumnEnd dropColumns(CqlIdentifier ... columnNames) {
        ImmutableSet.Builder builder = ImmutableSet.builder().addAll(this.columnsToDrop);
        for (CqlIdentifier columnName : columnNames) {
            builder = builder.add((Object)columnName);
        }
        return new DefaultAlterTable(this.keyspace, this.tableName, this.dropCompactStorage, this.allColumnsToAddInOrder, this.columnsToAddRegular, this.columnsToAddStatic, (ImmutableSet<CqlIdentifier>)builder.build(), this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.options);
    }

    @Override
    @NonNull
    public AlterTableRenameColumnEnd renameColumn(@NonNull CqlIdentifier from, @NonNull CqlIdentifier to) {
        return new DefaultAlterTable(this.keyspace, this.tableName, this.dropCompactStorage, this.allColumnsToAddInOrder, this.columnsToAddRegular, this.columnsToAddStatic, this.columnsToDrop, ImmutableCollections.append(this.columnsToRename, from, to), this.columnToAlter, this.columnToAlterType, this.options);
    }

    @Override
    @NonNull
    public BuildableQuery alterColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultAlterTable(this.keyspace, this.tableName, this.dropCompactStorage, this.allColumnsToAddInOrder, this.columnsToAddRegular, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, columnName, dataType, this.options);
    }

    @Override
    @NonNull
    public AlterTableWithOptionsEnd withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultAlterTable(this.keyspace, this.tableName, this.dropCompactStorage, this.allColumnsToAddInOrder, this.columnsToAddRegular, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        CqlHelper.qualify(this.keyspace, this.tableName, builder);
        if (this.columnToAlter != null) {
            return builder.append(" ALTER ").append(this.columnToAlter.asCql(true)).append(" TYPE ").append(this.columnToAlterType.asCql(true, true)).toString();
        }
        if (!this.allColumnsToAddInOrder.isEmpty()) {
            builder.append(" ADD ");
            if (this.allColumnsToAddInOrder.size() > 1) {
                builder.append('(');
            }
            boolean first = true;
            for (Map.Entry column : this.allColumnsToAddInOrder.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(((CqlIdentifier)column.getKey()).asCql(true)).append(' ').append(((DataType)column.getValue()).asCql(true, true));
                if (!this.columnsToAddStatic.contains(column.getKey())) continue;
                builder.append(" STATIC");
            }
            if (this.allColumnsToAddInOrder.size() > 1) {
                builder.append(')');
            }
            return builder.toString();
        }
        if (!this.columnsToDrop.isEmpty()) {
            boolean moreThanOneDrop = this.columnsToDrop.size() > 1;
            CqlHelper.appendIds(this.columnsToDrop, builder, moreThanOneDrop ? " DROP (" : " DROP ", ",", moreThanOneDrop ? ")" : "");
            return builder.toString();
        }
        if (!this.columnsToRename.isEmpty()) {
            builder.append(" RENAME ");
            boolean first = true;
            for (Map.Entry entry : this.columnsToRename.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" AND ");
                }
                builder.append(((CqlIdentifier)entry.getKey()).asCql(true)).append(" TO ").append(((CqlIdentifier)entry.getValue()).asCql(true));
            }
            return builder.toString();
        }
        if (this.dropCompactStorage) {
            return builder.append(" DROP COMPACT STORAGE").toString();
        }
        if (!this.options.isEmpty()) {
            return builder.append(OptionsUtils.buildOptions(this.options, true)).toString();
        }
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.tableName;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, DataType> getAllColumnsToAddInOrder() {
        return this.allColumnsToAddInOrder;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getColumnsToAddRegular() {
        return this.columnsToAddRegular;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getColumnsToAddStatic() {
        return this.columnsToAddStatic;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getColumnsToDrop() {
        return this.columnsToDrop;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, CqlIdentifier> getColumnsToRename() {
        return this.columnsToRename;
    }

    @Nullable
    public CqlIdentifier getColumnToAlter() {
        return this.columnToAlter;
    }

    @Nullable
    public DataType getColumnToAlterType() {
        return this.columnToAlterType;
    }

    public boolean isDropCompactStorage() {
        return this.dropCompactStorage;
    }
}

