/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.concurrent.LazyReference;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.graph.Graph;
import com.datastax.oss.driver.shaded.guava.common.graph.Graphs;
import com.datastax.oss.driver.shaded.guava.common.graph.MutableValueGraph;
import com.datastax.oss.driver.shaded.guava.common.graph.ValueGraphBuilder;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CycleDetector {
    private static final boolean ENABLED = Boolean.getBoolean("com.datastax.oss.driver.DETECT_CYCLES");
    private static final Logger LOG = LoggerFactory.getLogger(CycleDetector.class);
    private final String errorMessage;
    private final boolean enabled;
    private final MutableValueGraph<String, String> graph;

    public CycleDetector(String errorMessage) {
        this(errorMessage, ENABLED);
    }

    @VisibleForTesting
    CycleDetector(String errorMessage, boolean enabled) {
        this.errorMessage = errorMessage;
        this.enabled = enabled;
        this.graph = enabled ? ValueGraphBuilder.directed().build() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTryLock(LazyReference<?> reference) {
        if (this.enabled) {
            CycleDetector cycleDetector = this;
            synchronized (cycleDetector) {
                Thread me = Thread.currentThread();
                LOG.debug("{} wants to initialize {}", (Object)me, (Object)reference.getName());
                this.graph.putEdgeValue((Object)me.getName(), (Object)reference.getName(), (Object)"wants to initialize");
                LOG.debug("{}", this.graph);
                if (Graphs.hasCycle((Graph)this.graph.asGraph())) {
                    throw new IllegalStateException(this.errorMessage + " " + this.graph);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLockAcquired(LazyReference<?> reference) {
        if (this.enabled) {
            CycleDetector cycleDetector = this;
            synchronized (cycleDetector) {
                Thread me = Thread.currentThread();
                LOG.debug("{} is initializing {}", (Object)me, (Object)reference.getName());
                String old = (String)this.graph.removeEdge((Object)me.getName(), (Object)reference.getName());
                assert ("wants to initialize".equals(old));
                this.graph.putEdgeValue((Object)reference.getName(), (Object)me.getName(), (Object)"is getting initialized by");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReleaseLock(LazyReference<?> reference) {
        if (this.enabled) {
            CycleDetector cycleDetector = this;
            synchronized (cycleDetector) {
                Thread me = Thread.currentThread();
                LOG.debug("{} is done initializing {}", (Object)me, (Object)reference.getName());
                this.graph.removeEdge((Object)reference.getName(), (Object)me.getName());
            }
        }
    }
}

