/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class PasswordMessage
implements FrontendMessage {
    private final CharSequence password;

    public PasswordMessage(CharSequence password) {
        this.password = Assert.requireNonNull(password, "password must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 112);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeCStringUTF8(out, this.password);
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordMessage that = (PasswordMessage)o;
        return Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.password);
    }

    public String toString() {
        return "PasswordMessage{password='...'}";
    }
}

