/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.util;

import io.r2dbc.postgresql.util.Assert;
import java.util.regex.Pattern;

public final class GeneratedValuesUtils {
    private static final Pattern DELETE = Pattern.compile(".*DELETE.*", 34);
    private static final Pattern INSERT = Pattern.compile(".*INSERT.*", 34);
    private static final Pattern RETURNING = Pattern.compile(".*\\bRETURNING\\b.*", 34);
    private static final Pattern UPDATE = Pattern.compile(".*UPDATE.*", 34);

    private GeneratedValuesUtils() {
    }

    public static String augment(String sql, String[] generatedColumns) {
        Assert.requireNonNull(sql, "sql must not be null");
        Assert.requireNonNull(generatedColumns, "generatedColumns must not be null");
        return String.format("%s RETURNING %s", sql, generatedColumns.length == 0 ? "*" : String.join((CharSequence)", ", generatedColumns));
    }

    public static boolean hasReturningClause(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        return RETURNING.matcher(sql).matches();
    }

    public static boolean isSupportedCommand(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        return DELETE.matcher(sql).matches() || INSERT.matcher(sql).matches() || UPDATE.matcher(sql).matches();
    }
}

