/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.AbstractChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsHandler;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.channel.ContextAwareChannelMetricsRecorder;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

final class ContextAwareChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final ContextAwareChannelMetricsRecorder recorder;

    ContextAwareChannelMetricsHandler(ContextAwareChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ContextAwareConnectMetricsHandler(this.recorder(), this.proxyAddress);
    }

    @Override
    public ChannelHandler tlsMetricsHandler() {
        return new TlsMetricsHandler(this.recorder, this.remoteAddress, this.proxyAddress);
    }

    @Override
    public ContextAwareChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordException(ChannelHandlerContext ctx, SocketAddress address) {
        Connection connection = Connection.from(ctx.channel());
        ChannelOperations ops = connection.as(ChannelOperations.class);
        if (ops != null) {
            if (this.proxyAddress == null) {
                this.recorder().incrementErrorsCount((ContextView)ops.currentContext(), address);
            } else {
                this.recorder().incrementErrorsCount((ContextView)ops.currentContext(), address, this.proxyAddress);
            }
        } else if (connection instanceof ConnectionObserver) {
            if (this.proxyAddress == null) {
                this.recorder().incrementErrorsCount((ContextView)((ConnectionObserver)((Object)connection)).currentContext(), address);
            } else {
                this.recorder().incrementErrorsCount((ContextView)((ConnectionObserver)((Object)connection)).currentContext(), address, this.proxyAddress);
            }
        } else {
            super.recordException(ctx, address);
        }
    }

    @Override
    protected void recordRead(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
        if (ops != null) {
            if (this.proxyAddress == null) {
                this.recorder().recordDataReceived((ContextView)ops.currentContext(), address, bytes);
            } else {
                this.recorder().recordDataReceived((ContextView)ops.currentContext(), address, this.proxyAddress, bytes);
            }
        } else {
            super.recordRead(ctx, address, bytes);
        }
    }

    @Override
    protected void recordWrite(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
        if (ops != null) {
            if (this.proxyAddress == null) {
                this.recorder().recordDataSent((ContextView)ops.currentContext(), address, bytes);
            } else {
                this.recorder().recordDataSent((ContextView)ops.currentContext(), address, this.proxyAddress, bytes);
            }
        } else {
            super.recordWrite(ctx, address, bytes);
        }
    }

    static final class TlsMetricsHandler
    extends ChannelMetricsHandler.TlsMetricsHandler {
        TlsMetricsHandler(ContextAwareChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress) {
            super(recorder, remoteAddress, proxyAddress);
        }

        @Override
        protected void recordTlsHandshakeTime(ChannelHandlerContext ctx, long tlsHandshakeTimeStart, String status) {
            Connection connection = Connection.from(ctx.channel());
            if (connection instanceof ConnectionObserver) {
                if (this.proxyAddress == null) {
                    ((ContextAwareChannelMetricsRecorder)this.recorder).recordTlsHandshakeTime((ContextView)((ConnectionObserver)((Object)connection)).currentContext(), this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress(), Duration.ofNanos(System.nanoTime() - tlsHandshakeTimeStart), status);
                } else {
                    ((ContextAwareChannelMetricsRecorder)this.recorder).recordTlsHandshakeTime((ContextView)((ConnectionObserver)((Object)connection)).currentContext(), this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress(), this.proxyAddress, Duration.ofNanos(System.nanoTime() - tlsHandshakeTimeStart), status);
                }
            }
        }
    }

    static final class ContextAwareConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final SocketAddress proxyAddress;
        final ContextAwareChannelMetricsRecorder recorder;

        ContextAwareConnectMetricsHandler(ContextAwareChannelMetricsRecorder recorder, @Nullable SocketAddress proxyAddress) {
            this.proxyAddress = proxyAddress;
            this.recorder = recorder;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener(future -> {
                ctx.pipeline().remove((ChannelHandler)this);
                this.recordConnectTime(ctx, remoteAddress, connectTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR");
            });
        }

        void recordConnectTime(ChannelHandlerContext ctx, SocketAddress address, long connectTimeStart, String status) {
            Connection connection = Connection.from(ctx.channel());
            if (connection instanceof ConnectionObserver) {
                if (this.proxyAddress == null) {
                    this.recorder.recordConnectTime((ContextView)((ConnectionObserver)((Object)connection)).currentContext(), address, Duration.ofNanos(System.nanoTime() - connectTimeStart), status);
                } else {
                    this.recorder.recordConnectTime((ContextView)((ConnectionObserver)((Object)connection)).currentContext(), address, this.proxyAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), status);
                }
            } else if (this.proxyAddress == null) {
                this.recorder.recordConnectTime(address, Duration.ofNanos(System.nanoTime() - connectTimeStart), status);
            } else {
                this.recorder.recordConnectTime(address, this.proxyAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), status);
            }
        }
    }
}

