/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;

class ReIndexingContext {
    private final AtomicInteger successfullyReprocessedMails;
    private final AtomicInteger failedReprocessingMails = new AtomicInteger(0);
    private final ConcurrentLinkedDeque<ReIndexingExecutionFailures.ReIndexingFailure> failures;
    private final ConcurrentLinkedDeque<MailboxId> mailboxFailures;

    ReIndexingContext() {
        this.successfullyReprocessedMails = new AtomicInteger(0);
        this.failures = new ConcurrentLinkedDeque();
        this.mailboxFailures = new ConcurrentLinkedDeque();
    }

    void recordFailureDetailsForMessage(MailboxId mailboxId, MessageUid uid) {
        this.failures.add(new ReIndexingExecutionFailures.ReIndexingFailure(mailboxId, uid));
        this.failedReprocessingMails.incrementAndGet();
    }

    void recordSuccess() {
        this.successfullyReprocessedMails.incrementAndGet();
    }

    void recordMailboxFailure(MailboxId mailboxId) {
        this.mailboxFailures.add(mailboxId);
    }

    int successfullyReprocessedMailCount() {
        return this.successfullyReprocessedMails.get();
    }

    int failedReprocessingMailCount() {
        return this.failedReprocessingMails.get();
    }

    ReIndexingExecutionFailures failures() {
        return new ReIndexingExecutionFailures((List)ImmutableList.copyOf(this.failures), (List)ImmutableList.copyOf(this.mailboxFailures));
    }
}

