/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.memory;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.util.AuditTrail;
import org.apache.mailet.Mail;

public class MemoryMailRepository
implements MailRepository {
    private final ConcurrentHashMap<MailKey, Mail> mails = new ConcurrentHashMap();

    public MailKey store(Mail mail) throws MessagingException {
        MailKey mailKey = MailKey.forMail((Mail)mail);
        this.mails.put(mailKey, this.cloneMail(mail));
        AuditTrail.entry().protocol("mailrepository").action("store").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"recipients", (Object)StringUtils.join((Object[])new Collection[]{mail.getRecipients()})))).log("MemoryMailRepository stored mail.");
        return mailKey;
    }

    public Iterator<MailKey> list() {
        return ((ConcurrentHashMap.KeySetView)this.mails.keySet()).iterator();
    }

    public Mail retrieve(MailKey key) {
        return Optional.ofNullable(this.mails.get(key)).map(this::cloneMail).orElse(null);
    }

    public void remove(MailKey key) {
        this.mails.remove(key);
    }

    public long size() {
        return this.mails.size();
    }

    public void removeAll() {
        this.mails.clear();
    }

    private Mail cloneMail(Mail mail) {
        try {
            Mail newMail = mail.duplicate();
            newMail.setName(mail.getName());
            newMail.setState(mail.getState());
            return newMail;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

