/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.PropertyModel;

public class PropertyOrdering {
    private final Consumer<List<PropertyModel>> propertyOrderStrategy;

    public PropertyOrdering(Consumer<List<PropertyModel>> propertyOrderStrategy) {
        this.propertyOrderStrategy = Objects.requireNonNull(propertyOrderStrategy);
    }

    public List<PropertyModel> orderProperties(List<PropertyModel> properties, ClassModel classModel) {
        HashMap byReadName = new HashMap();
        properties.forEach(propertyModel -> byReadName.put(propertyModel.getPropertyName(), propertyModel));
        String[] order = classModel.getClassCustomization().getPropertyOrder();
        ArrayList<PropertyModel> sortedProperties = new ArrayList<PropertyModel>();
        if (order != null) {
            for (String propName : order) {
                PropertyModel remove = (PropertyModel)byReadName.remove(propName);
                if (remove == null) continue;
                sortedProperties.add(remove);
            }
        }
        ArrayList readNamesToSort = new ArrayList(byReadName.values());
        this.propertyOrderStrategy.accept(readNamesToSort);
        sortedProperties.addAll(readNamesToSort);
        return sortedProperties;
    }
}

