/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.IcuTransformDirection;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class IcuTransformTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final IcuTransformDirection dir;
    private final String id;
    public static final JsonpDeserializer<IcuTransformTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuTransformTokenFilter::setupIcuTransformTokenFilterDeserializer);

    private IcuTransformTokenFilter(Builder builder) {
        super(builder);
        this.dir = ApiTypeHelper.requireNonNull(builder.dir, this, "dir");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
    }

    public static IcuTransformTokenFilter of(Function<Builder, ObjectBuilder<IcuTransformTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuTransform;
    }

    public final IcuTransformDirection dir() {
        return this.dir;
    }

    public final String id() {
        return this.id;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_transform");
        super.serializeInternal(generator, mapper);
        generator.writeKey("dir");
        this.dir.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
    }

    protected static void setupIcuTransformTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::dir, IcuTransformDirection._DESERIALIZER, "dir");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuTransformTokenFilter> {
        private IcuTransformDirection dir;
        private String id;

        public final Builder dir(IcuTransformDirection value) {
            this.dir = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuTransformTokenFilter build() {
            this._checkSingleUse();
            return new IcuTransformTokenFilter(this);
        }
    }
}

