/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Objects;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity(name="Property")
@Table(name="JAMES_MAIL_PROPERTY")
public class JPAProperty
implements PersistenceCapable {
    @Id
    @GeneratedValue
    @Column(name="PROPERTY_ID", nullable=true)
    private long id;
    @Basic(optional=false)
    @Column(name="PROPERTY_LINE_NUMBER", nullable=false)
    @Index(name="INDEX_PROPERTY_LINE_NUMBER")
    private int line;
    @Basic(optional=false)
    @Column(name="PROPERTY_LOCAL_NAME", nullable=false, length=500)
    private String localName;
    @Basic(optional=false)
    @Column(name="PROPERTY_NAME_SPACE", nullable=false, length=500)
    private String namespace;
    @Basic(optional=false)
    @Column(name="PROPERTY_VALUE", nullable=false, length=1024)
    private String value;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    private transient Object pcDetachedState;

    @Deprecated
    public JPAProperty() {
    }

    public JPAProperty(String namespace, String localName, String value, int order) {
        this.localName = localName;
        this.namespace = namespace;
        this.value = value;
        this.line = order;
    }

    public JPAProperty(Property property, int order) {
        this(property.getNamespace(), property.getLocalName(), property.getValue(), order);
    }

    public Property toProperty() {
        return new Property(JPAProperty.pcGetnamespace(this), JPAProperty.pcGetlocalName(this), JPAProperty.pcGetvalue(this));
    }

    public final boolean equals(Object o) {
        if (o instanceof JPAProperty) {
            JPAProperty that = (JPAProperty)o;
            return Objects.equals(JPAProperty.pcGetid(this), JPAProperty.pcGetid(that));
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(JPAProperty.pcGetid(this));
    }

    public String toString() {
        return "JPAProperty ( id = " + JPAProperty.pcGetid(this) + " localName = " + JPAProperty.pcGetlocalName(this) + " namespace = " + JPAProperty.pcGetnamespace(this) + " value = " + JPAProperty.pcGetvalue(this) + " )";
    }

    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcFieldNames = new String[]{"id", "line", "localName", "namespace", "value"};
        pcFieldTypes = new Class[]{Long.TYPE, Integer.TYPE, String.class, String.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26};
        PCRegistry.register(JPAProperty.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Property", (PersistenceCapable)new JPAProperty());
    }

    protected void pcClearFields() {
        this.id = 0L;
        this.line = 0;
        this.localName = null;
        this.namespace = null;
        this.value = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAProperty jPAProperty = new JPAProperty();
        if (bl) {
            jPAProperty.pcClearFields();
        }
        jPAProperty.pcStateManager = stateManager;
        jPAProperty.pcCopyKeyFieldsFromObjectId(object);
        return jPAProperty;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAProperty jPAProperty = new JPAProperty();
        if (bl) {
            jPAProperty.pcClearFields();
        }
        jPAProperty.pcStateManager = stateManager;
        return jPAProperty;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.line = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.localName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.namespace = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.value = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 1: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.line);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.localName);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.namespace);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.value);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAProperty jPAProperty, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = jPAProperty.id;
                return;
            }
            case 1: {
                this.line = jPAProperty.line;
                return;
            }
            case 2: {
                this.localName = jPAProperty.localName;
                return;
            }
            case 3: {
                this.namespace = jPAProperty.namespace;
                return;
            }
            case 4: {
                this.value = jPAProperty.value;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPAProperty jPAProperty = (JPAProperty)object;
        if (jPAProperty.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAProperty, nArray[i]);
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(0 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(JPAProperty.class, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new LongId(JPAProperty.class, this.id);
    }

    private static final long pcGetid(JPAProperty jPAProperty) {
        if (jPAProperty.pcStateManager == null) {
            return jPAProperty.id;
        }
        int n = pcInheritedFieldCount + 0;
        jPAProperty.pcStateManager.accessingField(n);
        return jPAProperty.id;
    }

    private static final void pcSetid(JPAProperty jPAProperty, long l) {
        if (jPAProperty.pcStateManager == null) {
            jPAProperty.id = l;
            return;
        }
        jPAProperty.pcStateManager.settingLongField((PersistenceCapable)jPAProperty, pcInheritedFieldCount + 0, jPAProperty.id, l, 0);
    }

    private static final int pcGetline(JPAProperty jPAProperty) {
        if (jPAProperty.pcStateManager == null) {
            return jPAProperty.line;
        }
        int n = pcInheritedFieldCount + 1;
        jPAProperty.pcStateManager.accessingField(n);
        return jPAProperty.line;
    }

    private static final void pcSetline(JPAProperty jPAProperty, int n) {
        if (jPAProperty.pcStateManager == null) {
            jPAProperty.line = n;
            return;
        }
        jPAProperty.pcStateManager.settingIntField((PersistenceCapable)jPAProperty, pcInheritedFieldCount + 1, jPAProperty.line, n, 0);
    }

    private static final String pcGetlocalName(JPAProperty jPAProperty) {
        if (jPAProperty.pcStateManager == null) {
            return jPAProperty.localName;
        }
        int n = pcInheritedFieldCount + 2;
        jPAProperty.pcStateManager.accessingField(n);
        return jPAProperty.localName;
    }

    private static final void pcSetlocalName(JPAProperty jPAProperty, String string) {
        if (jPAProperty.pcStateManager == null) {
            jPAProperty.localName = string;
            return;
        }
        jPAProperty.pcStateManager.settingStringField((PersistenceCapable)jPAProperty, pcInheritedFieldCount + 2, jPAProperty.localName, string, 0);
    }

    private static final String pcGetnamespace(JPAProperty jPAProperty) {
        if (jPAProperty.pcStateManager == null) {
            return jPAProperty.namespace;
        }
        int n = pcInheritedFieldCount + 3;
        jPAProperty.pcStateManager.accessingField(n);
        return jPAProperty.namespace;
    }

    private static final void pcSetnamespace(JPAProperty jPAProperty, String string) {
        if (jPAProperty.pcStateManager == null) {
            jPAProperty.namespace = string;
            return;
        }
        jPAProperty.pcStateManager.settingStringField((PersistenceCapable)jPAProperty, pcInheritedFieldCount + 3, jPAProperty.namespace, string, 0);
    }

    private static final String pcGetvalue(JPAProperty jPAProperty) {
        if (jPAProperty.pcStateManager == null) {
            return jPAProperty.value;
        }
        int n = pcInheritedFieldCount + 4;
        jPAProperty.pcStateManager.accessingField(n);
        return jPAProperty.value;
    }

    private static final void pcSetvalue(JPAProperty jPAProperty, String string) {
        if (jPAProperty.pcStateManager == null) {
            jPAProperty.value = string;
            return;
        }
        jPAProperty.pcStateManager.settingStringField((PersistenceCapable)jPAProperty, pcInheritedFieldCount + 4, jPAProperty.value, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

