/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class VerifyPasswordExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String VERIFY_PASSWORD_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.72";
    @NotNull
    public static final String REQUEST_FIELD_DN = "dn";
    @NotNull
    public static final String REQUEST_FIELD_PASSWORD = "password";
    private static final long serialVersionUID = 4632159563446607461L;
    @NotNull
    private final String dn;
    @NotNull
    private final String password;

    public VerifyPasswordExtendedRequest(@NotNull String dn, @NotNull String password, Control ... controls) {
        super(VERIFY_PASSWORD_REQUEST_OID, VerifyPasswordExtendedRequest.encodeValue(dn, password), controls);
        this.dn = dn;
        this.password = password;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String dn, @NotNull String password) {
        Validator.ensureNotNullOrEmpty(dn, "VerifyPasswordExtendedRequest.dn must not be null or empty");
        Validator.ensureNotNullOrEmpty(password, "VerifyPasswordExtendedRequest.password must not be null or empty");
        JSONObject requestObject = new JSONObject(new JSONField(REQUEST_FIELD_DN, dn), new JSONField(REQUEST_FIELD_PASSWORD, password));
        return new ASN1OctetString(requestObject.toSingleLineString());
    }

    public VerifyPasswordExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        JSONObject requestObject;
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VERIFY_PASSWORD_REQUEST_NO_VALUE.get());
        }
        try {
            requestObject = new JSONObject(value.stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VERIFY_PASSWORD_REQUEST_CANNOT_DECODE_VALUE.get());
        }
        this.dn = requestObject.getFieldAsString(REQUEST_FIELD_DN);
        if (this.dn == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VERIFY_PASSWORD_REQUEST_MISSING_FIELD.get(REQUEST_FIELD_DN));
        }
        if (this.dn.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VERIFY_PASSWORD_REQUEST_EMPTY_FIELD.get(REQUEST_FIELD_DN));
        }
        this.password = requestObject.getFieldAsString(REQUEST_FIELD_PASSWORD);
        if (this.password == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VERIFY_PASSWORD_REQUEST_MISSING_FIELD.get(REQUEST_FIELD_PASSWORD));
        }
        if (this.password.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VERIFY_PASSWORD_REQUEST_EMPTY_FIELD.get(REQUEST_FIELD_PASSWORD));
        }
    }

    @NotNull
    public String getDN() {
        return this.dn;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public VerifyPasswordExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public VerifyPasswordExtendedRequest duplicate(@Nullable Control[] controls) {
        VerifyPasswordExtendedRequest r = new VerifyPasswordExtendedRequest(this.dn, this.password, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_VERIFY_PASSWORD.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("VerifyPasswordExtendedRequest(dn='");
        buffer.append(this.dn);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

