/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.mime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mailbox.store.search.comparator.SentDateComparator;
import org.apache.james.mailbox.store.search.mime.EMailer;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.MimeUtil;

public class HeaderCollection {
    public static final String TO = "to";
    public static final String FROM = "from";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String REPLY_TO = "reply-to";
    public static final String SUBJECT = "subject";
    public static final String DATE = "date";
    public static final String MESSAGE_ID = "message-id";
    private final ImmutableSet<EMailer> toAddressSet;
    private final ImmutableSet<EMailer> fromAddressSet;
    private final ImmutableSet<EMailer> ccAddressSet;
    private final ImmutableSet<EMailer> bccAddressSet;
    private final ImmutableSet<EMailer> replyToAddressSet;
    private final ImmutableSet<String> subjectSet;
    private final List<Header> headers;
    private final Optional<ZonedDateTime> sentDate;
    private final Optional<String> messageID;

    public static Builder builder() {
        return new Builder();
    }

    private HeaderCollection(ImmutableSet<EMailer> toAddressSet, ImmutableSet<EMailer> fromAddressSet, ImmutableSet<EMailer> ccAddressSet, ImmutableSet<EMailer> bccAddressSet, ImmutableSet<EMailer> replyToAddressSet, ImmutableSet<String> subjectSet, List<Header> headers, Optional<ZonedDateTime> sentDate, Optional<String> messageID) {
        this.toAddressSet = toAddressSet;
        this.fromAddressSet = fromAddressSet;
        this.ccAddressSet = ccAddressSet;
        this.bccAddressSet = bccAddressSet;
        this.replyToAddressSet = replyToAddressSet;
        this.subjectSet = subjectSet;
        this.headers = headers;
        this.sentDate = sentDate;
        this.messageID = messageID;
    }

    public Set<EMailer> getToAddressSet() {
        return this.toAddressSet;
    }

    public Set<EMailer> getFromAddressSet() {
        return this.fromAddressSet;
    }

    public Set<EMailer> getCcAddressSet() {
        return this.ccAddressSet;
    }

    public Set<EMailer> getBccAddressSet() {
        return this.bccAddressSet;
    }

    public Set<EMailer> getReplyToAddressSet() {
        return this.replyToAddressSet;
    }

    public Set<String> getSubjectSet() {
        return this.subjectSet;
    }

    public Optional<ZonedDateTime> getSentDate() {
        return this.sentDate;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public Optional<String> getMessageID() {
        return this.messageID;
    }

    public static class Builder {
        private final ImmutableSet.Builder<EMailer> toAddressSet = ImmutableSet.builder();
        private final ImmutableSet.Builder<EMailer> fromAddressSet = ImmutableSet.builder();
        private final ImmutableSet.Builder<EMailer> ccAddressSet = ImmutableSet.builder();
        private final ImmutableSet.Builder<EMailer> bccAddressSet = ImmutableSet.builder();
        private final ImmutableSet.Builder<EMailer> replyToAddressSet = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> subjectSet = ImmutableSet.builder();
        private final ImmutableList.Builder<Header> headers = ImmutableList.builder();
        private Optional<ZonedDateTime> sentDate = Optional.empty();
        private Optional<String> messageID = Optional.empty();

        private Builder() {
        }

        public Builder add(Field field) {
            Preconditions.checkNotNull((Object)field);
            String headerName = field.getName().toLowerCase(Locale.US);
            String rawHeaderValue = field.getBody();
            String sanitizedValue = MimeUtil.unscrambleHeaderValue((String)rawHeaderValue);
            this.headers.add((Object)new Header(headerName, sanitizedValue));
            this.handleSpecificHeader(headerName, sanitizedValue, rawHeaderValue);
            return this;
        }

        public HeaderCollection build() {
            return new HeaderCollection((ImmutableSet<EMailer>)this.toAddressSet.build(), (ImmutableSet<EMailer>)this.fromAddressSet.build(), (ImmutableSet<EMailer>)this.ccAddressSet.build(), (ImmutableSet<EMailer>)this.bccAddressSet.build(), (ImmutableSet<EMailer>)this.replyToAddressSet.build(), (ImmutableSet<String>)this.subjectSet.build(), (List<Header>)this.headers.build(), this.sentDate, this.messageID);
        }

        private void handleSpecificHeader(String headerName, String headerValue, String rawHeaderValue) {
            switch (headerName) {
                case "to": 
                case "from": 
                case "cc": 
                case "bcc": 
                case "reply-to": {
                    this.manageAddressField(headerName, rawHeaderValue);
                    break;
                }
                case "subject": {
                    this.subjectSet.add((Object)SearchUtil.getBaseSubject(headerValue));
                    break;
                }
                case "date": {
                    this.sentDate = SentDateComparator.toISODate(headerValue);
                    break;
                }
                case "message-id": {
                    this.messageID = Optional.ofNullable(headerValue);
                }
            }
        }

        private void manageAddressField(String headerName, String rawHeaderValue) {
            ImmutableSet.Builder<EMailer> addressSet = this.getAddressSet(headerName);
            LenientAddressParser.DEFAULT.parseAddressList((CharSequence)rawHeaderValue).flatten().stream().map(mailbox -> new EMailer(Optional.ofNullable(mailbox.getName()), mailbox.getAddress(), mailbox.getDomain())).forEach(arg_0 -> addressSet.add(arg_0));
        }

        private ImmutableSet.Builder<EMailer> getAddressSet(String headerName) {
            switch (headerName) {
                case "to": {
                    return this.toAddressSet;
                }
                case "from": {
                    return this.fromAddressSet;
                }
                case "cc": {
                    return this.ccAddressSet;
                }
                case "bcc": {
                    return this.bccAddressSet;
                }
                case "reply-to": {
                    return this.replyToAddressSet;
                }
            }
            throw new RuntimeException(headerName + " is not a address header name");
        }
    }

    public static class Header {
        private final String headerName;
        private final String value;

        Header(String headerName, String value) {
            this.headerName = headerName;
            this.value = value;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public String getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Header) {
                Header header = (Header)o;
                return Objects.equals(this.headerName, header.headerName) && Objects.equals(this.value, header.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.headerName, this.value);
        }
    }
}

