/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.Username;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPassCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;

public abstract class AbstractApopCmdHandler
extends AbstractPassCmdHandler {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"APOP");
    private static final String MISSING_APOP_TIMESTAMP = "";

    @Inject
    public AbstractApopCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        if (!session.getAttachment(POP3Session.APOP_TIMESTAMP, ProtocolSession.State.Connection).isPresent()) {
            return POP3Response.ERR;
        }
        String parameters = request.getArgument();
        String[] parts = null;
        boolean syntaxError = false;
        if (parameters != null) {
            parts = StringUtils.split((String)parameters, (String)" ");
            if (parts.length != 2) {
                syntaxError = true;
            }
        } else {
            syntaxError = true;
        }
        if (!syntaxError && session.getHandlerState() == 0) {
            Username username = Username.of((String)parts[0]);
            Response response = this.doAuth(session, username, parts[1]);
            if ("+OK".equals(response.getRetCode())) {
                session.setUsername(username);
            }
            return response;
        }
        session.setHandlerState(0);
        return AUTH_FAILED;
    }

    @Override
    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected final Mailbox auth(POP3Session session, Username username, String password) throws Exception {
        return this.auth(session, session.getAttachment(POP3Session.APOP_TIMESTAMP, ProtocolSession.State.Connection).orElse(MISSING_APOP_TIMESTAMP), username, password);
    }

    protected abstract Mailbox auth(POP3Session var1, String var2, Username var3, String var4) throws Exception;
}

