/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging.error;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.time.ZonedDateTime;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerInfos;
import reactor.netty.http.server.logging.error.AbstractErrorLogArgProvider;
import reactor.util.annotation.Nullable;

final class DefaultErrorLogArgProvider
extends AbstractErrorLogArgProvider<DefaultErrorLogArgProvider> {
    private Throwable cause;
    private ZonedDateTime errorDateTime;
    private HttpServerInfos httpServerInfos;

    DefaultErrorLogArgProvider(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public ZonedDateTime errorDateTime() {
        return this.errorDateTime;
    }

    @Override
    public DefaultErrorLogArgProvider get() {
        return this;
    }

    @Override
    @Nullable
    public HttpServerInfos httpServerInfos() {
        return this.httpServerInfos;
    }

    void clear() {
        this.cause = null;
        this.errorDateTime = null;
        this.httpServerInfos = null;
    }

    void applyConnectionInfo(Channel channel) {
        ChannelOperations ops = ChannelOperations.get((Channel)channel);
        if (ops instanceof HttpServerInfos) {
            this.httpServerInfos = (HttpServerInfos)ops;
        }
    }

    void applyThrowable(Throwable cause) {
        this.cause = cause;
        this.errorDateTime = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
    }
}

