/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.crypto.pem;

import de.dentrassi.crypto.pem.AbstractPemKeyStore;
import de.dentrassi.crypto.pem.PemReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PemUtils {
    private static final String SOURCE_PREFIX = "source.";

    public static Map<String, AbstractPemKeyStore.Entry> loadFrom(InputStream stream, boolean chained) throws CertificateException, IOException {
        HashMap<String, AbstractPemKeyStore.Entry> result = new HashMap<String, AbstractPemKeyStore.Entry>();
        PemUtils.loadFrom(result, "pem", chained, stream);
        return result;
    }

    public static Map<String, AbstractPemKeyStore.Entry> loadFromConfiguration(InputStream stream) throws CertificateException, IOException {
        HashMap<String, AbstractPemKeyStore.Entry> result = new HashMap<String, AbstractPemKeyStore.Entry>();
        Properties p = new Properties();
        p.load(stream);
        String alias = p.getProperty("alias", "pem");
        for (String key : p.stringPropertyNames()) {
            if (!key.startsWith(SOURCE_PREFIX)) continue;
            InputStream source = PemUtils.openResource(p.getProperty(key));
            try {
                PemUtils.loadFrom(result, alias, true, source);
            }
            finally {
                if (source == null) continue;
                source.close();
            }
        }
        return result;
    }

    private static InputStream openResource(String uri) throws IOException {
        if (uri.startsWith("classpath:")) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(uri.substring(10));
        }
        return new FileInputStream(uri.startsWith("file://") ? uri.substring(7) : uri);
    }

    private static void loadFrom(Map<String, AbstractPemKeyStore.Entry> result, String alias, boolean chained, InputStream stream) throws CertificateException, IOException {
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        PrivateKey key = null;
        int counter = 0;
        try (PemReader pemReader = new PemReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            Object object;
            while ((object = pemReader.readObject()) != null) {
                if (object instanceof Certificate) {
                    Certificate cert = (Certificate)object;
                    if (chained) {
                        if (!(cert instanceof X509Certificate)) continue;
                        chain.add(cert);
                        continue;
                    }
                    result.put(alias + "-" + counter++, new AbstractPemKeyStore.Entry(null, new Certificate[]{cert}));
                    continue;
                }
                if (object instanceof KeyPair) {
                    key = ((KeyPair)object).getPrivate();
                    continue;
                }
                if (!(object instanceof PrivateKey)) continue;
                key = (PrivateKey)object;
            }
        }
        Certificate[] certificateChain = chain.isEmpty() ? null : (Certificate[])chain.toArray(new X509Certificate[chain.size()]);
        AbstractPemKeyStore.Entry e = new AbstractPemKeyStore.Entry(key, certificateChain);
        result.compute(alias, (k, v) -> {
            if (v != null) {
                return v.merge(e);
            }
            return e;
        });
    }
}

