/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AlarmSeverity {
    INDETERMINATE,
    NORMAL,
    WARNING,
    MINOR,
    MAJOR,
    CRITICAL;


    @Nullable
    public static AlarmSeverity forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "indeterminate": {
                return INDETERMINATE;
            }
            case "normal": {
                return NORMAL;
            }
            case "warning": {
                return WARNING;
            }
            case "minor": {
                return MINOR;
            }
            case "major": {
                return MAJOR;
            }
            case "critical": {
                return CRITICAL;
            }
        }
        return null;
    }
}

