/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetUserResourceLimitsResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_USER_RESOURCE_LIMITS_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.26";
    private static final byte TYPE_SIZE_LIMIT = -128;
    private static final byte TYPE_TIME_LIMIT = -127;
    private static final byte TYPE_IDLE_TIME_LIMIT = -126;
    private static final byte TYPE_LOOKTHROUGH_LIMIT = -125;
    private static final byte TYPE_EQUIVALENT_AUTHZ_USER_DN = -124;
    private static final byte TYPE_CLIENT_CONNECTION_POLICY_NAME = -123;
    private static final byte TYPE_GROUP_DNS = -90;
    private static final byte TYPE_PRIVILEGE_NAMES = -89;
    private static final byte TYPE_OTHER_ATTRIBUTES = -88;
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTE_NAME = "name";
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTE_VALUES = "values";
    @NotNull
    private static final String JSON_FIELD_CLIENT_CONNECTION_POLICY_NAME = "client-connection-policy-name";
    @NotNull
    private static final String JSON_FIELD_EQUIVALENT_AUTHZ_USER_DN = "equivalent-authorization-user-dn";
    @NotNull
    private static final String JSON_FIELD_GROUP_DNS = "group-dns";
    @NotNull
    private static final String JSON_FIELD_IDLE_TIME_LIMIT_SECONDS = "idle-time-limit-seconds";
    @NotNull
    private static final String JSON_FIELD_LOOKTHROUGH_LIMIT = "lookthrough-limit";
    @NotNull
    private static final String JSON_FIELD_OTHER_ATTRIBUTES = "other-attributes";
    @NotNull
    private static final String JSON_FIELD_PRIVILEGE_NAMES = "privilege-names";
    @NotNull
    private static final String JSON_FIELD_SIZE_LIMIT = "size-limit";
    @NotNull
    private static final String JSON_FIELD_TIME_LIMIT_SECONDS = "time-limit-seconds";
    private static final long serialVersionUID = -5261978490319320250L;
    @NotNull
    private final List<Attribute> otherAttributes;
    @Nullable
    private final List<String> groupDNs;
    @Nullable
    private final List<String> privilegeNames;
    @Nullable
    private final Long idleTimeLimitSeconds;
    @Nullable
    private final Long lookthroughLimit;
    @Nullable
    private final Long sizeLimit;
    @Nullable
    private final Long timeLimitSeconds;
    @Nullable
    private final String clientConnectionPolicyName;
    @Nullable
    private final String equivalentAuthzUserDN;

    GetUserResourceLimitsResponseControl() {
        this.otherAttributes = null;
        this.groupDNs = null;
        this.privilegeNames = null;
        this.idleTimeLimitSeconds = null;
        this.lookthroughLimit = null;
        this.sizeLimit = null;
        this.timeLimitSeconds = null;
        this.clientConnectionPolicyName = null;
        this.equivalentAuthzUserDN = null;
    }

    public GetUserResourceLimitsResponseControl(@Nullable Long sizeLimit, @Nullable Long timeLimitSeconds, @Nullable Long idleTimeLimitSeconds, @Nullable Long lookthroughLimit, @Nullable String equivalentAuthzUserDN, @Nullable String clientConnectionPolicyName) {
        this(sizeLimit, timeLimitSeconds, idleTimeLimitSeconds, lookthroughLimit, equivalentAuthzUserDN, clientConnectionPolicyName, null, null, null);
    }

    public GetUserResourceLimitsResponseControl(@Nullable Long sizeLimit, @Nullable Long timeLimitSeconds, @Nullable Long idleTimeLimitSeconds, @Nullable Long lookthroughLimit, @Nullable String equivalentAuthzUserDN, @Nullable String clientConnectionPolicyName, @Nullable List<String> groupDNs, @Nullable List<String> privilegeNames, @Nullable List<Attribute> otherAttributes) {
        super(GET_USER_RESOURCE_LIMITS_RESPONSE_OID, false, GetUserResourceLimitsResponseControl.encodeValue(sizeLimit, timeLimitSeconds, idleTimeLimitSeconds, lookthroughLimit, equivalentAuthzUserDN, clientConnectionPolicyName, groupDNs, privilegeNames, otherAttributes));
        this.sizeLimit = sizeLimit == null || sizeLimit > 0L ? sizeLimit : Long.valueOf(-1L);
        this.timeLimitSeconds = timeLimitSeconds == null || timeLimitSeconds > 0L ? timeLimitSeconds : Long.valueOf(-1L);
        this.idleTimeLimitSeconds = idleTimeLimitSeconds == null || idleTimeLimitSeconds > 0L ? idleTimeLimitSeconds : Long.valueOf(-1L);
        this.lookthroughLimit = lookthroughLimit == null || lookthroughLimit > 0L ? lookthroughLimit : Long.valueOf(-1L);
        this.equivalentAuthzUserDN = equivalentAuthzUserDN;
        this.clientConnectionPolicyName = clientConnectionPolicyName;
        this.groupDNs = groupDNs == null ? null : Collections.unmodifiableList(new ArrayList<String>(groupDNs));
        this.privilegeNames = privilegeNames == null ? null : Collections.unmodifiableList(new ArrayList<String>(privilegeNames));
        this.otherAttributes = otherAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Attribute>(otherAttributes));
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable Long sizeLimit, @Nullable Long timeLimitSeconds, @Nullable Long idleTimeLimitSeconds, @Nullable Long lookthroughLimit, @Nullable String equivalentAuthzUserDN, @Nullable String clientConnectionPolicyName, @Nullable List<String> groupDNs, @Nullable List<String> privilegeNames, @Nullable List<Attribute> otherAttributes) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(10);
        if (sizeLimit != null) {
            if (sizeLimit > 0L) {
                elements.add(new ASN1Long(-128, sizeLimit));
            } else {
                elements.add(new ASN1Long(-128, -1L));
            }
        }
        if (timeLimitSeconds != null) {
            if (timeLimitSeconds > 0L) {
                elements.add(new ASN1Long(-127, timeLimitSeconds));
            } else {
                elements.add(new ASN1Long(-127, -1L));
            }
        }
        if (idleTimeLimitSeconds != null) {
            if (idleTimeLimitSeconds > 0L) {
                elements.add(new ASN1Long(-126, idleTimeLimitSeconds));
            } else {
                elements.add(new ASN1Long(-126, -1L));
            }
        }
        if (lookthroughLimit != null) {
            if (lookthroughLimit > 0L) {
                elements.add(new ASN1Long(-125, lookthroughLimit));
            } else {
                elements.add(new ASN1Long(-125, -1L));
            }
        }
        if (equivalentAuthzUserDN != null) {
            elements.add(new ASN1OctetString(-124, equivalentAuthzUserDN));
        }
        if (clientConnectionPolicyName != null) {
            elements.add(new ASN1OctetString(-123, clientConnectionPolicyName));
        }
        if (groupDNs != null) {
            ArrayList<ASN1OctetString> dnElements = new ArrayList<ASN1OctetString>(groupDNs.size());
            for (String s : groupDNs) {
                dnElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Set(-90, dnElements));
        }
        if (privilegeNames != null) {
            ArrayList<ASN1OctetString> privElements = new ArrayList<ASN1OctetString>(privilegeNames.size());
            for (String s : privilegeNames) {
                privElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Set(-89, privElements));
        }
        if (otherAttributes != null && !otherAttributes.isEmpty()) {
            ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(otherAttributes.size());
            for (Attribute a : otherAttributes) {
                attrElements.add(a.encode());
            }
            elements.add(new ASN1Sequence(-88, attrElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public GetUserResourceLimitsResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_MISSING_VALUE.get());
        }
        List oa = Collections.emptyList();
        List<String> gd = null;
        List<String> pn = null;
        Long sL = null;
        Long tL = null;
        Long iTL = null;
        Long lL = null;
        String eAUD = null;
        String cCPN = null;
        try {
            ASN1Element[] elements;
            block13: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        sL = ASN1Long.decodeAsLong(e).longValue();
                        continue block13;
                    }
                    case -127: {
                        tL = ASN1Long.decodeAsLong(e).longValue();
                        continue block13;
                    }
                    case -126: {
                        iTL = ASN1Long.decodeAsLong(e).longValue();
                        continue block13;
                    }
                    case -125: {
                        lL = ASN1Long.decodeAsLong(e).longValue();
                        continue block13;
                    }
                    case -124: {
                        eAUD = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block13;
                    }
                    case -123: {
                        cCPN = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block13;
                    }
                    case -90: {
                        ASN1Element[] groupElements = ASN1Set.decodeAsSet(e).elements();
                        gd = new ArrayList(groupElements.length);
                        for (ASN1Element pe : groupElements) {
                            gd.add(ASN1OctetString.decodeAsOctetString(pe).stringValue());
                        }
                        gd = Collections.unmodifiableList(gd);
                        continue block13;
                    }
                    case -89: {
                        ASN1Element[] privElements = ASN1Set.decodeAsSet(e).elements();
                        pn = new ArrayList(privElements.length);
                        for (ASN1Element pe : privElements) {
                            pn.add(ASN1OctetString.decodeAsOctetString(pe).stringValue());
                        }
                        pn = Collections.unmodifiableList(pn);
                        continue block13;
                    }
                    case -88: {
                        ASN1Element[] attrElemnets = ASN1Sequence.decodeAsSequence(e).elements();
                        oa = new ArrayList(attrElemnets.length);
                        for (ASN1Element ae : attrElemnets) {
                            oa.add(Attribute.decode(ASN1Sequence.decodeAsSequence(ae)));
                        }
                        oa = Collections.unmodifiableList(oa);
                        continue block13;
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.otherAttributes = oa;
        this.groupDNs = gd;
        this.privilegeNames = pn;
        this.sizeLimit = sL;
        this.timeLimitSeconds = tL;
        this.idleTimeLimitSeconds = iTL;
        this.lookthroughLimit = lL;
        this.equivalentAuthzUserDN = eAUD;
        this.clientConnectionPolicyName = cCPN;
    }

    @Override
    @NotNull
    public GetUserResourceLimitsResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetUserResourceLimitsResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static GetUserResourceLimitsResponseControl get(@NotNull BindResult result) throws LDAPException {
        Control c = result.getResponseControl(GET_USER_RESOURCE_LIMITS_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetUserResourceLimitsResponseControl) {
            return (GetUserResourceLimitsResponseControl)c;
        }
        return new GetUserResourceLimitsResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Nullable
    public Long getSizeLimit() {
        return this.sizeLimit;
    }

    @Nullable
    public Long getTimeLimitSeconds() {
        return this.timeLimitSeconds;
    }

    @Nullable
    public Long getIdleTimeLimitSeconds() {
        return this.idleTimeLimitSeconds;
    }

    @Nullable
    public Long getLookthroughLimit() {
        return this.lookthroughLimit;
    }

    @Nullable
    public String getEquivalentAuthzUserDN() {
        return this.equivalentAuthzUserDN;
    }

    @Nullable
    public String getClientConnectionPolicyName() {
        return this.clientConnectionPolicyName;
    }

    @Nullable
    public List<String> getGroupDNs() {
        return this.groupDNs;
    }

    @Nullable
    public List<String> getPrivilegeNames() {
        return this.privilegeNames;
    }

    @NotNull
    public List<Attribute> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Nullable
    public Attribute getOtherAttribute(@NotNull String name) {
        for (Attribute a : this.otherAttributes) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_USER_RESOURCE_LIMITS_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (this.sizeLimit != null) {
            valueFields.put(JSON_FIELD_SIZE_LIMIT, new JSONNumber(this.sizeLimit));
        }
        if (this.timeLimitSeconds != null) {
            valueFields.put(JSON_FIELD_TIME_LIMIT_SECONDS, new JSONNumber(this.timeLimitSeconds));
        }
        if (this.idleTimeLimitSeconds != null) {
            valueFields.put(JSON_FIELD_IDLE_TIME_LIMIT_SECONDS, new JSONNumber(this.idleTimeLimitSeconds));
        }
        if (this.lookthroughLimit != null) {
            valueFields.put(JSON_FIELD_LOOKTHROUGH_LIMIT, new JSONNumber(this.lookthroughLimit));
        }
        if (this.equivalentAuthzUserDN != null) {
            valueFields.put(JSON_FIELD_EQUIVALENT_AUTHZ_USER_DN, new JSONString(this.equivalentAuthzUserDN));
        }
        if (this.clientConnectionPolicyName != null) {
            valueFields.put(JSON_FIELD_CLIENT_CONNECTION_POLICY_NAME, new JSONString(this.clientConnectionPolicyName));
        }
        if (this.groupDNs != null) {
            ArrayList<JSONString> groupDNValues = new ArrayList<JSONString>(this.groupDNs.size());
            for (String groupDN : this.groupDNs) {
                groupDNValues.add(new JSONString(groupDN));
            }
            valueFields.put(JSON_FIELD_GROUP_DNS, new JSONArray(groupDNValues));
        }
        if (this.privilegeNames != null) {
            ArrayList<JSONString> privilegeNameValues = new ArrayList<JSONString>(this.privilegeNames.size());
            for (String privilegeName : this.privilegeNames) {
                privilegeNameValues.add(new JSONString(privilegeName));
            }
            valueFields.put(JSON_FIELD_PRIVILEGE_NAMES, new JSONArray(privilegeNameValues));
        }
        if (this.otherAttributes != null && !this.otherAttributes.isEmpty()) {
            ArrayList<JSONObject> otherAttributesValues = new ArrayList<JSONObject>(this.otherAttributes.size());
            for (Attribute a : this.otherAttributes) {
                ArrayList<JSONString> attributeValues = new ArrayList<JSONString>(a.size());
                for (String value : a.getValues()) {
                    attributeValues.add(new JSONString(value));
                }
                otherAttributesValues.add(new JSONObject(new JSONField(JSON_FIELD_ATTRIBUTE_NAME, a.getName()), new JSONField(JSON_FIELD_ATTRIBUTE_VALUES, new JSONArray(attributeValues))));
            }
            valueFields.put(JSON_FIELD_OTHER_ATTRIBUTES, new JSONArray(otherAttributesValues));
        }
        return new JSONObject(new JSONField("oid", GET_USER_RESOURCE_LIMITS_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_USER_RESOURCE_LIMITS_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static GetUserResourceLimitsResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ArrayList<String> privilegeNames;
        ArrayList<String> groupDNs;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetUserResourceLimitsResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Long sizeLimit = valueObject.getFieldAsLong(JSON_FIELD_SIZE_LIMIT);
        Long timeLimitSeconds = valueObject.getFieldAsLong(JSON_FIELD_TIME_LIMIT_SECONDS);
        Long idleTimeLimitSeconds = valueObject.getFieldAsLong(JSON_FIELD_IDLE_TIME_LIMIT_SECONDS);
        Long lookthroughLimit = valueObject.getFieldAsLong(JSON_FIELD_LOOKTHROUGH_LIMIT);
        String equivalentAuthZUserDN = valueObject.getFieldAsString(JSON_FIELD_EQUIVALENT_AUTHZ_USER_DN);
        String clientConnectionPolicyName = valueObject.getFieldAsString(JSON_FIELD_CLIENT_CONNECTION_POLICY_NAME);
        List<JSONValue> groupDNValues = valueObject.getFieldAsArray(JSON_FIELD_GROUP_DNS);
        if (groupDNValues == null) {
            groupDNs = null;
        } else {
            groupDNs = new ArrayList<String>(groupDNValues.size());
            for (JSONValue v : groupDNValues) {
                if (v instanceof JSONString) {
                    groupDNs.add(((JSONString)v).stringValue());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_JSON_ARRAY_VALUE_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_GROUP_DNS));
            }
        }
        List<JSONValue> privilegeNameValues = valueObject.getFieldAsArray(JSON_FIELD_PRIVILEGE_NAMES);
        if (privilegeNameValues == null) {
            privilegeNames = null;
        } else {
            privilegeNames = new ArrayList<String>(privilegeNameValues.size());
            for (JSONValue v : privilegeNameValues) {
                if (v instanceof JSONString) {
                    privilegeNames.add(((JSONString)v).stringValue());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_JSON_ARRAY_VALUE_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_PRIVILEGE_NAMES));
            }
        }
        ArrayList<Attribute> otherAttributes = new ArrayList<Attribute>();
        List<JSONValue> otherAttributeValues = valueObject.getFieldAsArray(JSON_FIELD_OTHER_ATTRIBUTES);
        if (otherAttributeValues != null) {
            for (JSONValue otherAttributeValue : otherAttributeValues) {
                if (otherAttributeValue instanceof JSONObject) {
                    JSONObject o = (JSONObject)otherAttributeValue;
                    String name = o.getFieldAsString(JSON_FIELD_ATTRIBUTE_NAME);
                    if (name == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_JSON_MISSING_ATTR_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_OTHER_ATTRIBUTES, JSON_FIELD_ATTRIBUTE_NAME));
                    }
                    List<JSONValue> valueValues = o.getFieldAsArray(JSON_FIELD_ATTRIBUTE_VALUES);
                    if (valueValues == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_JSON_MISSING_ATTR_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_OTHER_ATTRIBUTES, JSON_FIELD_ATTRIBUTE_VALUES));
                    }
                    ArrayList<String> values = new ArrayList<String>(valueValues.size());
                    for (JSONValue v : valueValues) {
                        if (v instanceof JSONString) {
                            values.add(((JSONString)v).stringValue());
                            continue;
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_JSON_VALUE_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_OTHER_ATTRIBUTES, JSON_FIELD_ATTRIBUTE_VALUES));
                    }
                    otherAttributes.add(new Attribute(name, values));
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_JSON_ATTR_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_OTHER_ATTRIBUTES));
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SIZE_LIMIT, JSON_FIELD_TIME_LIMIT_SECONDS, JSON_FIELD_IDLE_TIME_LIMIT_SECONDS, JSON_FIELD_TIME_LIMIT_SECONDS, JSON_FIELD_LOOKTHROUGH_LIMIT, JSON_FIELD_EQUIVALENT_AUTHZ_USER_DN, JSON_FIELD_CLIENT_CONNECTION_POLICY_NAME, JSON_FIELD_GROUP_DNS, JSON_FIELD_PRIVILEGE_NAMES, JSON_FIELD_OTHER_ATTRIBUTES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetUserResourceLimitsResponseControl(sizeLimit, timeLimitSeconds, idleTimeLimitSeconds, lookthroughLimit, equivalentAuthZUserDN, clientConnectionPolicyName, groupDNs, privilegeNames, otherAttributes);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetUserResourceLimitsResponseControl(");
        boolean added = false;
        if (this.sizeLimit != null) {
            buffer.append("sizeLimit=");
            buffer.append(this.sizeLimit);
            added = true;
        }
        if (this.timeLimitSeconds != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("timeLimitSeconds=");
            buffer.append(this.timeLimitSeconds);
            added = true;
        }
        if (this.idleTimeLimitSeconds != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("idleTimeLimitSeconds=");
            buffer.append(this.idleTimeLimitSeconds);
            added = true;
        }
        if (this.lookthroughLimit != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("lookthroughLimit=");
            buffer.append(this.lookthroughLimit);
            added = true;
        }
        if (this.equivalentAuthzUserDN != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("equivalentAuthzUserDN=\"");
            buffer.append(this.equivalentAuthzUserDN);
            buffer.append('\"');
            added = true;
        }
        if (this.clientConnectionPolicyName != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("clientConnectionPolicyName=\"");
            buffer.append(this.clientConnectionPolicyName);
            buffer.append('\"');
            added = true;
        }
        if (this.groupDNs != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("groupDNs={");
            Iterator<String> dnIterator = this.groupDNs.iterator();
            while (dnIterator.hasNext()) {
                buffer.append('\"');
                buffer.append(dnIterator.next());
                buffer.append('\"');
                if (!dnIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
            added = true;
        }
        if (this.privilegeNames != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("privilegeNames={");
            Iterator<String> privilegeIterator = this.privilegeNames.iterator();
            while (privilegeIterator.hasNext()) {
                buffer.append('\"');
                buffer.append(privilegeIterator.next());
                buffer.append('\"');
                if (!privilegeIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
            added = true;
        }
        if (!this.otherAttributes.isEmpty()) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("otherAttributes={");
            Iterator<Attribute> attrIterator = this.otherAttributes.iterator();
            while (attrIterator.hasNext()) {
                attrIterator.next().toString(buffer);
                if (!attrIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append("')");
    }
}

