/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PurgeRetiredListenerCertificatesExtendedResult;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PurgeRetiredListenerCertificatesExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String PURGE_RETIRED_LISTENER_CERTS_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.70";
    private static final long serialVersionUID = 3182708156067344907L;

    public PurgeRetiredListenerCertificatesExtendedRequest(Control ... requestControls) {
        super(PURGE_RETIRED_LISTENER_CERTS_REQUEST_OID, null, requestControls);
    }

    public PurgeRetiredListenerCertificatesExtendedRequest(@NotNull ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value != null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PURGE_RETIRED_LISTENER_CERTS_REQ_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public PurgeRetiredListenerCertificatesExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new PurgeRetiredListenerCertificatesExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_PURGE_RETIRED_LISTENER_CERTS_REQUEST_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PurgeRetiredListenerCertificatesExtendedRequest(oid='");
        buffer.append(this.getOID());
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

