/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class AttributeBasedLogFieldSyntaxHelper {
    private AttributeBasedLogFieldSyntaxHelper() {
    }

    @NotNull
    static Set<String> getAttributeSet(@Nullable Schema schema, @Nullable Collection<String> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> attrSet = new HashSet<String>();
        for (String attr : attrs) {
            AttributeTypeDefinition attrType = schema == null ? null : schema.getAttributeType(attr);
            if (attrType == null) {
                attrSet.add(StaticUtils.toLowerCase(attr));
                continue;
            }
            attrSet.add(StaticUtils.toLowerCase(attrType.getOID()));
            for (String name : attrType.getNames()) {
                attrSet.add(StaticUtils.toLowerCase(name));
            }
        }
        return Collections.unmodifiableSet(attrSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String tokenizeValue(@NotNull LogFieldSyntax<?> syntax, @Nullable Schema schema, @NotNull String attributeName, @NotNull byte[] attributeValue, @NotNull byte[] pepper) {
        ASN1OctetString normalizedValue;
        ASN1OctetString nonNormalizedValue = new ASN1OctetString(attributeValue);
        try {
            MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(attributeName, schema);
            normalizedValue = matchingRule.normalize(nonNormalizedValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            normalizedValue = nonNormalizedValue;
        }
        ByteStringBuffer tokenizeBuffer = syntax.getTemporaryBuffer();
        try {
            syntax.tokenize(normalizedValue.getValue(), pepper, tokenizeBuffer);
            String string = tokenizeBuffer.toString();
            return string;
        }
        finally {
            syntax.releaseTemporaryBuffer(tokenizeBuffer);
        }
    }
}

