/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.Serializable;
import java.security.Provider;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TrustStoreTrustManagerProperties
implements Serializable {
    private static final long serialVersionUID = 4782995125532803023L;
    private boolean allowNonFIPSInFIPSMode;
    private boolean examineValidityDates;
    @Nullable
    private char[] trustStorePIN;
    @Nullable
    private Provider provider;
    @NotNull
    private String trustStorePath;
    @Nullable
    private String trustStoreFormat;

    public TrustStoreTrustManagerProperties(@NotNull File trustStoreFile) {
        this(trustStoreFile.getAbsolutePath());
    }

    public TrustStoreTrustManagerProperties(@NotNull String trustStorePath) {
        Validator.ensureNotNull(trustStorePath);
        this.trustStorePath = trustStorePath;
        this.trustStorePIN = null;
        this.trustStoreFormat = null;
        this.provider = null;
        this.examineValidityDates = true;
        this.allowNonFIPSInFIPSMode = false;
    }

    @NotNull
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStoreFile(@NotNull File trustStoreFile) {
        Validator.ensureNotNull(trustStoreFile);
        this.trustStorePath = trustStoreFile.getAbsolutePath();
    }

    public void setTrustStorePath(@NotNull String trustStorePath) {
        Validator.ensureNotNull(trustStorePath);
        this.trustStorePath = trustStorePath;
    }

    @Nullable
    public char[] getTrustStorePIN() {
        return this.trustStorePIN;
    }

    public void setTrustStorePIN(@Nullable char[] trustStorePIN) {
        this.trustStorePIN = trustStorePIN;
    }

    public void setTrustStorePIN(@Nullable String trustStorePIN) {
        this.trustStorePIN = (char[])(trustStorePIN == null ? null : trustStorePIN.toCharArray());
    }

    @Nullable
    public String getTrustStoreFormat() {
        return this.trustStoreFormat;
    }

    public void setTrustStoreFormat(@Nullable String trustStoreFormat) {
        this.trustStoreFormat = trustStoreFormat;
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    public void setExamineValidityDates(boolean examineValidityDates) {
        this.examineValidityDates = examineValidityDates;
    }

    @Nullable
    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(@Nullable Provider provider) {
        this.provider = provider;
    }

    public boolean allowNonFIPSInFIPSMode() {
        return this.allowNonFIPSInFIPSMode;
    }

    public void setAllowNonFIPSInFIPSMode(boolean allowNonFIPSInFIPSMode) {
        this.allowNonFIPSInFIPSMode = allowNonFIPSInFIPSMode;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TrustStoreTrustManagerProperties(trustStorePath='");
        buffer.append(this.trustStorePath);
        buffer.append('\'');
        buffer.append(", trustStorePINProvided=");
        buffer.append(this.trustStorePIN != null);
        if (this.trustStoreFormat != null) {
            buffer.append(", trustStoreFormat='");
            buffer.append(this.trustStoreFormat);
            buffer.append('\'');
        }
        buffer.append(", examineValidityDates=");
        buffer.append(this.examineValidityDates);
        if (this.provider != null) {
            buffer.append(", providerClass='");
            buffer.append(this.provider.getClass().getName());
            buffer.append('\'');
        }
        buffer.append(", allowNonFIPSInFIPSMode=");
        buffer.append(this.allowNonFIPSInFIPSMode);
        buffer.append(')');
    }
}

