/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.codecs.quantization;

import java.io.IOException;
import java.util.Random;
import java.util.function.IntUnaryOperator;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;

public class SampleReader
extends FloatVectorValues
implements HasIndexSlice {
    private final FloatVectorValues origin;
    private final int sampleSize;
    private final IntUnaryOperator sampleFunction;

    SampleReader(FloatVectorValues origin, int sampleSize, IntUnaryOperator sampleFunction) {
        this.origin = origin;
        this.sampleSize = sampleSize;
        this.sampleFunction = sampleFunction;
    }

    public int size() {
        return this.sampleSize;
    }

    public int dimension() {
        return this.origin.dimension();
    }

    public FloatVectorValues copy() throws IOException {
        throw new IllegalStateException("Not supported");
    }

    public IndexInput getSlice() {
        return ((HasIndexSlice)this.origin).getSlice();
    }

    public float[] vectorValue(int targetOrd) throws IOException {
        return this.origin.vectorValue(this.sampleFunction.applyAsInt(targetOrd));
    }

    public int getVectorByteLength() {
        return this.origin.getVectorByteLength();
    }

    public int ordToDoc(int ord) {
        throw new IllegalStateException("Not supported");
    }

    public Bits getAcceptOrds(Bits acceptDocs) {
        throw new IllegalStateException("Not supported");
    }

    public static SampleReader createSampleReader(FloatVectorValues origin, int k, long seed) {
        int[] samples = SampleReader.reservoirSample(origin.size(), k, seed);
        return new SampleReader(origin, samples.length, i -> samples[i]);
    }

    public static int[] reservoirSample(int n, int k, long seed) {
        int i;
        Random rnd = new Random(seed);
        int[] reservoir = new int[k];
        for (i = 0; i < k; ++i) {
            reservoir[i] = i;
        }
        for (i = k; i < n; ++i) {
            int j = rnd.nextInt(i + 1);
            if (j >= k) continue;
            reservoir[j] = i;
        }
        return reservoir;
    }

    public static int[] reservoirSampleFromArray(int[] origin, int k, long seed) {
        int i;
        Random rnd = new Random(seed);
        if (k >= origin.length) {
            return origin;
        }
        int[] reservoir = new int[k];
        for (i = 0; i < k; ++i) {
            reservoir[i] = origin[i];
        }
        for (i = k; i < origin.length; ++i) {
            int j = rnd.nextInt(i + 1);
            if (j >= k) continue;
            reservoir[j] = origin[i];
        }
        return reservoir;
    }
}

