/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.DecodingException;
import io.jsonwebtoken.io.Encoder;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;

public class Codec
implements Converter<byte[], CharSequence> {
    public static final Codec BASE64 = new Codec((Encoder<byte[], String>)Encoders.BASE64, (Decoder<CharSequence, byte[]>)Decoders.BASE64);
    public static final Codec BASE64URL = new Codec((Encoder<byte[], String>)Encoders.BASE64URL, (Decoder<CharSequence, byte[]>)Decoders.BASE64URL);
    private final Encoder<byte[], String> encoder;
    private final Decoder<CharSequence, byte[]> decoder;

    public Codec(Encoder<byte[], String> encoder, Decoder<CharSequence, byte[]> decoder) {
        this.encoder = (Encoder)Assert.notNull(encoder, (String)"Encoder cannot be null.");
        this.decoder = (Decoder)Assert.notNull(decoder, (String)"Decoder cannot be null.");
    }

    @Override
    public String applyTo(byte[] a) {
        return (String)this.encoder.encode((Object)a);
    }

    @Override
    public byte[] applyFrom(CharSequence b) {
        try {
            return (byte[])this.decoder.decode((Object)b);
        }
        catch (DecodingException e) {
            String msg = "Cannot decode input String. Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

