/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;
import java.util.concurrent.atomic.AtomicInteger;

public class PositiveIntegerConverter
implements Converter<Integer, Object> {
    public static final PositiveIntegerConverter INSTANCE = new PositiveIntegerConverter();

    @Override
    public Object applyTo(Integer integer) {
        return integer;
    }

    @Override
    public Integer applyFrom(Object o) {
        int i;
        Assert.notNull((Object)o, (String)"Argument cannot be null.");
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof AtomicInteger) {
            i = ((Number)o).intValue();
        } else {
            String sval = String.valueOf(o);
            try {
                i = Integer.parseInt(sval);
            }
            catch (NumberFormatException e) {
                String msg = "Value cannot be represented as a java.lang.Integer.";
                throw new IllegalArgumentException(msg, e);
            }
        }
        if (i <= 0) {
            String msg = "Value must be a positive integer.";
            throw new IllegalArgumentException(msg);
        }
        return i;
    }
}

