/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import jakarta.mail.internet.AddressException;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import javax.management.MalformedObjectNameException;
import org.apache.commons.lang3.EnumUtils;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.DropListManagementMBean;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.util.MDCBuilder;

public class JmxDropListProbe
implements JmxProbe {
    private static final String DROPLIST_OBJECT_NAME = "org.apache.james:type=component,name=droplist";
    private static final String JMX = "JMX";
    private DropListManagementMBean dropListProxy;

    @Override
    public JmxDropListProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.dropListProxy = jmxc.retrieveBean(DropListManagementMBean.class, DROPLIST_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public void addDropListEntry(String ownerScope, String owner, String deniedEntity) throws Exception {
        try (Closeable closeable = this.buildMdc("addDropListEntry");){
            DropListEntry dropListEntry = this.getDropListEntry(this.checkValidOwnerScope(ownerScope), owner, deniedEntity);
            this.dropListProxy.add(dropListEntry);
        }
    }

    public void removeDropListEntry(String ownerScope, String owner, String deniedEntity) throws Exception {
        try (Closeable closeable = this.buildMdc("removeDropListEntry");){
            DropListEntry dropListEntry = this.getDropListEntry(this.checkValidOwnerScope(ownerScope), owner, deniedEntity);
            this.dropListProxy.remove(dropListEntry);
        }
    }

    public List<String> getDropList(String ownerScope, String owner) throws Exception {
        try (Closeable closeable = this.buildMdc("getDropList");){
            List list = this.dropListProxy.list(this.checkValidOwnerScope(ownerScope), owner);
            return list;
        }
    }

    public String runDropListQuery(String ownerScope, String owner, String deniedEntity) throws Exception {
        try (Closeable closeable = this.buildMdc("dropListQuery");){
            String string = this.dropListProxy.query(this.checkValidOwnerScope(ownerScope), owner, JmxDropListProbe.checkValidMailAddress(deniedEntity));
            return string;
        }
    }

    private Closeable buildMdc(String action) {
        return MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", action).build();
    }

    private DropListEntry getDropListEntry(OwnerScope ownerScope, String owner, String deniedEntity) {
        DropListEntry.Builder dropListEntryBuilder = DropListEntry.builder();
        switch (ownerScope) {
            case GLOBAL: {
                dropListEntryBuilder = dropListEntryBuilder.forAll();
                break;
            }
            case DOMAIN: {
                dropListEntryBuilder = dropListEntryBuilder.domainOwner(this.checkValidDomain(owner));
                break;
            }
            case USER: {
                dropListEntryBuilder = dropListEntryBuilder.userOwner(JmxDropListProbe.checkValidMailAddress(owner));
            }
        }
        if (deniedEntity.contains("@")) {
            dropListEntryBuilder.denyAddress(JmxDropListProbe.checkValidMailAddress(deniedEntity));
        } else {
            dropListEntryBuilder.denyDomain(this.checkValidDomain(deniedEntity));
        }
        return dropListEntryBuilder.build();
    }

    private static MailAddress checkValidMailAddress(String address) {
        try {
            return new MailAddress(address);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException("Invalid mail address " + address);
        }
    }

    private Domain checkValidDomain(String domainName) {
        try {
            return Domain.of((String)domainName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid domain " + domainName);
        }
    }

    private OwnerScope checkValidOwnerScope(String ownerScope) {
        try {
            return OwnerScope.valueOf((String)ownerScope.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("OwnerScope '" + ownerScope + "' is invalid. Supported values are " + String.valueOf(EnumUtils.getEnumList(OwnerScope.class)));
        }
    }
}

