/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFRecordParser;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.parser.MatcherBasedConfiguration;
import org.apache.james.jspf.parser.TermDefinition;
import org.apache.james.jspf.parser.TermsFactory;
import org.apache.james.jspf.terms.Directive;
import org.apache.james.jspf.terms.Mechanism;
import org.apache.james.jspf.terms.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFC4408SPF1Parser
implements SPFRecordParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RFC4408SPF1Parser.class);
    private static final String QUALIFIER_PATTERN = "[\\+\\-\\?\\~]";
    private Pattern termsSeparatorPattern = null;
    private Pattern termPattern = null;
    private int TERM_STEP_REGEX_QUALIFIER_POS;
    private int TERM_STEP_REGEX_MECHANISM_POS;
    private int TERM_STEP_REGEX_MODIFIER_POS;
    private List<TermDefinition> matchResultPositions;
    private TermsFactory termsFactory;

    public RFC4408SPF1Parser(TermsFactory termsFactory) {
        this.termsFactory = termsFactory;
        String MECHANISM_REGEX = this.createRegex(termsFactory.getMechanismsCollection());
        String MODIFIER_REGEX = "(" + this.createRegex(termsFactory.getModifiersCollection()) + ")";
        String DIRECTIVE_REGEX = "([\\+\\-\\?\\~]?)(" + MECHANISM_REGEX + ")";
        String TERM_REGEX = "(?:" + MODIFIER_REGEX + "|" + DIRECTIVE_REGEX + ")";
        String TERMS_SEPARATOR_REGEX = "[ ]+";
        this.termsSeparatorPattern = Pattern.compile(TERMS_SEPARATOR_REGEX);
        this.termPattern = Pattern.compile(TERM_REGEX);
        this.initializePositions();
    }

    private void initializePositions() {
        int k;
        int size;
        ArrayList<TermDefinition> matchResultPositions = new ArrayList<TermDefinition>();
        int posIndex = 0;
        matchResultPositions.ensureCapacity(posIndex + 1);
        matchResultPositions.add(posIndex, null);
        this.TERM_STEP_REGEX_MODIFIER_POS = ++posIndex;
        matchResultPositions.ensureCapacity(posIndex + 1);
        matchResultPositions.add(this.TERM_STEP_REGEX_MODIFIER_POS, null);
        for (TermDefinition td : this.termsFactory.getModifiersCollection()) {
            size = td.getMatchSize() + 1;
            for (k = 0; k < size; ++k) {
                matchResultPositions.ensureCapacity(++posIndex + 1);
                matchResultPositions.add(posIndex, td);
            }
        }
        this.TERM_STEP_REGEX_QUALIFIER_POS = ++posIndex;
        matchResultPositions.ensureCapacity(posIndex + 1);
        matchResultPositions.add(posIndex, null);
        this.TERM_STEP_REGEX_MECHANISM_POS = ++posIndex;
        matchResultPositions.ensureCapacity(posIndex + 1);
        matchResultPositions.add(this.TERM_STEP_REGEX_MECHANISM_POS, null);
        for (TermDefinition td : this.termsFactory.getMechanismsCollection()) {
            size = td.getMatchSize() + 1;
            for (k = 0; k < size; ++k) {
                matchResultPositions.ensureCapacity(++posIndex + 1);
                matchResultPositions.add(posIndex, td);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing catch group positions: Modifiers[{}] Qualifier[{}] Mechanism[{}]", new Object[]{this.TERM_STEP_REGEX_MODIFIER_POS, this.TERM_STEP_REGEX_QUALIFIER_POS, this.TERM_STEP_REGEX_MECHANISM_POS});
            for (int k2 = 0; k2 < matchResultPositions.size(); ++k2) {
                LOGGER.debug("{}) {}", (Object)k2, matchResultPositions.get(k2) != null ? ((TermDefinition)matchResultPositions.get(k2)).getPattern().pattern() : null);
            }
        }
        this.matchResultPositions = Collections.synchronizedList(matchResultPositions);
    }

    private String createRegex(Collection<TermDefinition> commandMap) {
        StringBuffer modifierRegex = new StringBuffer();
        Iterator<TermDefinition> i = commandMap.iterator();
        boolean first = true;
        while (i.hasNext()) {
            if (first) {
                modifierRegex.append("(?:(");
                first = false;
            } else {
                modifierRegex.append(")|(");
            }
            Pattern pattern = i.next().getPattern();
            modifierRegex.append(pattern.pattern());
        }
        modifierRegex.append("))");
        return modifierRegex.toString();
    }

    @Override
    public SPF1Record parse(String spfRecord) throws PermErrorException, NoneException, NeutralException {
        LOGGER.debug("Start parsing SPF-Record: " + spfRecord);
        SPF1Record result = new SPF1Record();
        if (spfRecord.toLowerCase().startsWith("v=spf1 ") || spfRecord.equalsIgnoreCase("v=spf1")) {
            if (!spfRecord.toLowerCase().startsWith("v=spf1 ")) {
                throw new NeutralException("Empty SPF Record");
            }
        } else {
            throw new NoneException("No valid SPF Record: " + spfRecord);
        }
        String[] terms = this.termsSeparatorPattern.split(spfRecord.replaceFirst("v=spf1", ""));
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].length() <= 0) continue;
            Matcher termMatcher = this.termPattern.matcher(terms[i]);
            if (!termMatcher.matches()) {
                throw new PermErrorException("Term [" + terms[i] + "] is not syntactically valid: " + this.termPattern.pattern());
            }
            String modifierString = termMatcher.group(this.TERM_STEP_REGEX_MODIFIER_POS);
            if (modifierString != null) {
                Modifier mod = (Modifier)this.lookupAndCreateTerm(termMatcher, this.TERM_STEP_REGEX_MODIFIER_POS);
                if (mod.enforceSingleInstance()) {
                    Iterator<Modifier> it = result.getModifiers().iterator();
                    while (it.hasNext()) {
                        if (!it.next().getClass().equals(mod.getClass())) continue;
                        throw new PermErrorException("More than one " + modifierString + " found in SPF-Record");
                    }
                }
                result.getModifiers().add(mod);
                continue;
            }
            String qualifier = termMatcher.group(this.TERM_STEP_REGEX_QUALIFIER_POS);
            Object mech = this.lookupAndCreateTerm(termMatcher, this.TERM_STEP_REGEX_MECHANISM_POS);
            result.getDirectives().add(new Directive(qualifier, (Mechanism)mech));
        }
        return result;
    }

    private Object lookupAndCreateTerm(Matcher res, int start) throws PermErrorException {
        for (int k = start + 1; k < res.groupCount(); ++k) {
            if (res.group(k) == null || k == this.TERM_STEP_REGEX_QUALIFIER_POS) continue;
            TermDefinition c = this.matchResultPositions.get(k);
            MatcherBasedConfiguration subres = new MatcherBasedConfiguration(res, k, c.getMatchSize());
            try {
                return this.termsFactory.createTerm(c.getTermDef(), subres);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new IllegalStateException("Unexpected error creating term: " + e.getMessage());
            }
        }
        return null;
    }
}

