/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.context.web;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.james.container.spring.resource.DefaultJamesResourceLoader;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JamesServerWebApplicationContext
extends XmlWebApplicationContext
implements JamesResourceLoader {
    private final JamesResourceLoader resourceLoader = new DefaultJamesResourceLoader(new JamesDirectoriesProvider(){

        public String getAbsoluteDirectory() {
            if (JamesServerWebApplicationContext.this.absoluteDirectory == null) {
                return this.getRootDirectory();
            }
            return JamesServerWebApplicationContext.this.absoluteDirectory;
        }

        public String getConfDirectory() {
            return Objects.requireNonNullElseGet(JamesServerWebApplicationContext.this.confDirectory, () -> this.getRootDirectory() + "/WEB-INF/conf/");
        }

        public String getRootDirectory() {
            if (JamesServerWebApplicationContext.this.rootDirectory == null) {
                return JamesServerWebApplicationContext.this.getServletContext().getRealPath("/");
            }
            return JamesServerWebApplicationContext.this.rootDirectory;
        }

        public String getVarDirectory() {
            return Objects.requireNonNullElseGet(JamesServerWebApplicationContext.this.varDirectory, () -> this.getRootDirectory() + "/var/");
        }
    });
    private String rootDirectory;
    private String absoluteDirectory;
    private String varDirectory;
    private String confDirectory;

    @Override
    public void validate(File file) throws IOException {
        this.resourceLoader.validate(file);
    }

    public Resource getResource(String fileURL) {
        Resource r = this.resourceLoader.getResource(fileURL);
        if (r == null) {
            r = super.getResource(fileURL);
        }
        return r;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void setAbsoluteDirectory(String absoluteDirectory) {
        this.absoluteDirectory = absoluteDirectory;
    }

    public void setVarDirectory(String varDirectory) {
        this.varDirectory = varDirectory;
    }

    public void setConfDirectory(String confDirectory) {
        this.confDirectory = confDirectory;
    }

    public String getAbsoluteDirectory() {
        return this.resourceLoader.getAbsoluteDirectory();
    }

    public String getConfDirectory() {
        return this.resourceLoader.getConfDirectory();
    }

    public String getVarDirectory() {
        return this.resourceLoader.getVarDirectory();
    }

    public String getRootDirectory() {
        return this.resourceLoader.getRootDirectory();
    }
}

