/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.apache.james.fetchmail.Account;
import org.apache.james.fetchmail.MessageProcessor;
import org.apache.james.fetchmail.ProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderProcessor
extends ProcessorAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderProcessor.class);
    private Folder fieldFolder;
    private Boolean fieldMarkSeenPermanent;

    protected FolderProcessor(Folder folder, Account account) {
        super(account);
        this.setFolder(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void process() throws MessagingException {
        block21: {
            int messagesProcessed = 0;
            int messageCount = 0;
            try {
                this.open();
            }
            catch (MessagingException ex2333333332) {
                LOGGER.error("{} Failed to open folder!", (Object)this.getFetchTaskName());
                throw ex2333333332;
            }
            Folder ex2333333332 = this.getFolder();
            synchronized (ex2333333332) {
                messageCount = this.getFolder().getMessageCount();
                for (int i = 1; i <= messageCount; ++i) {
                    MimeMessage message = (MimeMessage)this.getFolder().getMessage(i);
                    if (!this.isFetchAll() && this.isSeen(message)) continue;
                    try {
                        new MessageProcessor(message, this.getAccount()).process();
                        ++messagesProcessed;
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.error("Exception processing message ID: {}", (Object)message.getMessageID(), (Object)ex);
                    }
                }
            }
            try {
                this.close();
            }
            catch (MessagingException ex2333333332) {
                // empty catch block
            }
            LOGGER.info("Processed {} messages of {} in folder '{}'", new Object[]{messagesProcessed, messageCount, this.getFolder().getName()});
            break block21;
            catch (MessagingException mex222222222) {
                try {
                    LOGGER.error("A MessagingException has terminated fetching messages for this folder", (Throwable)mex222222222);
                }
                catch (Throwable throwable) {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        // empty catch block
                    }
                    LOGGER.info("Processed {} messages of {} in folder '{}'", new Object[]{messagesProcessed, messageCount, this.getFolder().getName()});
                    throw throwable;
                }
                try {
                    this.close();
                }
                catch (MessagingException mex222222222) {
                    // empty catch block
                }
                LOGGER.info("Processed {} messages of {} in folder '{}'", new Object[]{messagesProcessed, messageCount, this.getFolder().getName()});
            }
        }
        try {
            if (this.isRecurse()) {
                this.recurse();
            }
        }
        catch (MessagingException mex) {
            LOGGER.error("A MessagingException has terminated recursing through sub-folders", (Throwable)mex);
        }
    }

    protected void close() throws MessagingException {
        if (null != this.getFolder() && this.getFolder().isOpen()) {
            this.getFolder().close(true);
        }
    }

    protected void recurse() throws MessagingException {
        if ((this.getFolder().getType() & 2) == 2) {
            Folder[] folders;
            for (Folder folder : folders = this.getFolder().list()) {
                new FolderProcessor(folder, this.getAccount()).process();
            }
        }
    }

    protected void open() throws MessagingException {
        int openFlag = 2;
        if (this.isOpenReadOnly()) {
            openFlag = 1;
        }
        this.getFolder().open(openFlag);
    }

    protected Folder getFolder() {
        return this.fieldFolder;
    }

    protected boolean isSeen(MimeMessage aMessage) throws MessagingException {
        boolean isSeen = this.isMarkSeenPermanent() != false ? aMessage.isSet(Flags.Flag.SEEN) : this.handleMarkSeenNotPermanent(aMessage);
        return isSeen;
    }

    protected Boolean computeMarkSeenPermanent() {
        return this.getFolder().getPermanentFlags().contains(Flags.Flag.SEEN);
    }

    protected boolean handleMarkSeenNotPermanent(MimeMessage aMessage) throws MessagingException {
        return aMessage.isSet(Flags.Flag.SEEN);
    }

    protected void setFolder(Folder folder) {
        this.fieldFolder = folder;
    }

    protected Boolean isMarkSeenPermanent() {
        Boolean markSeenPermanent = this.isMarkSeenPermanentBasic();
        if (null == markSeenPermanent) {
            this.updateMarkSeenPermanent();
            return this.isMarkSeenPermanent();
        }
        return markSeenPermanent;
    }

    private Boolean isMarkSeenPermanentBasic() {
        return this.fieldMarkSeenPermanent;
    }

    protected void setMarkSeenPermanent(Boolean markSeenPermanent) {
        this.fieldMarkSeenPermanent = markSeenPermanent;
    }

    protected void updateMarkSeenPermanent() {
        this.setMarkSeenPermanent(this.computeMarkSeenPermanent());
    }
}

