/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.apache.james.protocols.pop3.core.POP3MessageCommandDelegate;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;

public class ListCmdHandler
extends AbstractPOP3CommandHandler {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"LIST");
    private final MetricFactory metricFactory;
    private final POP3MessageCommandDelegate commandDelegate;

    @Inject
    public ListCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
        this.commandDelegate = new POP3MessageCommandDelegate(this, COMMANDS){

            protected POP3Response handleMessageExists(POP3Session session, MessageMetaData data, POP3MessageCommandArguments args) {
                return new POP3Response("+OK", args.getMessageNumber() + " " + data.getSize());
            }
        };
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-list", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "LIST").addToContext(MDCConstants.withSession(session)).addToContext(MDCConstants.forRequest(request)), () -> this.handleMessageRequest(session, request)));
    }

    private Response handleMessageRequest(POP3Session session, Request request) {
        if (request.getArgument() != null) {
            return this.commandDelegate.handleMessageRequest(session, request);
        }
        if (session.getHandlerState() == 2) {
            List uidList = (List)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            List deletedUidList = (List)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            long totalSize = 0L;
            ArrayList<CallSite> validResults = new ArrayList<CallSite>();
            for (int i = 0; i < uidList.size(); ++i) {
                MessageMetaData data = (MessageMetaData)uidList.get(i);
                if (deletedUidList.contains(data.getUid())) continue;
                totalSize += data.getSize();
                validResults.add((CallSite)((Object)(i + 1 + " " + data.getSize())));
            }
            POP3Response response = new POP3Response("+OK", validResults.size() + " " + totalSize);
            validResults.forEach(arg_0 -> ((POP3Response)response).appendLine(arg_0));
            response.appendLine(".");
            return response;
        }
        return POP3Response.ERR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

