/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.RestCallLoggerRule;

public class RestCallLoggerConfig {
    public static final RestCallLoggerConfig DEFAULT = RestCallLoggerConfig.create().build();
    public static final RestCallLoggerConfig DEFAULT_DEBUG = RestCallLoggerConfig.create().useStackTraceHashing(false).level(Level.WARNING).rules(RestCallLoggerRule.create().codes("*").verbose().build()).build();
    private final RestCallLoggerRule[] rules;
    private final boolean useStackTraceHashing;
    private final Enablement disabled;
    private final int stackTraceHashingTimeout;
    private final Level level;

    RestCallLoggerConfig(Builder b) {
        RestCallLoggerConfig p = b.parent;
        Enablement enablement = b.disabled != null ? b.disabled : (this.disabled = p != null ? p.disabled : Enablement.FALSE);
        boolean bl = b.useStackTraceHashing != null ? b.useStackTraceHashing : (this.useStackTraceHashing = p != null ? p.useStackTraceHashing : false);
        int n = b.stackTraceHashingTimeout != null ? b.stackTraceHashingTimeout : (this.stackTraceHashingTimeout = p != null ? p.stackTraceHashingTimeout : Integer.MAX_VALUE);
        this.level = b.level != null ? b.level : (p != null ? p.level : Level.INFO);
        ArrayList<RestCallLoggerRule> rules = new ArrayList<RestCallLoggerRule>();
        rules.addAll(b.rules);
        if (p != null) {
            rules.addAll(Arrays.asList(p.rules));
        }
        this.rules = rules.toArray(new RestCallLoggerRule[rules.size()]);
    }

    public static Builder create() {
        return new Builder();
    }

    public RestCallLoggerRule getRule(HttpServletRequest req, HttpServletResponse res) {
        int status = res.getStatus();
        Throwable e = (Throwable)req.getAttribute("Exception");
        boolean debug = this.isDebug(req);
        for (RestCallLoggerRule r : this.rules) {
            if (!r.matches(status, debug, e)) continue;
            Enablement disabled = r.getDisabled();
            if (disabled == null) {
                disabled = this.disabled;
            }
            if (disabled == Enablement.TRUE) {
                return null;
            }
            if (this.isNoTraceAttr(req)) {
                return null;
            }
            if (disabled == Enablement.FALSE) {
                return r;
            }
            if (this.isNoTraceHeader(req)) {
                return null;
            }
            return r;
        }
        return null;
    }

    public boolean isDisabled(HttpServletRequest req) {
        if (this.disabled == Enablement.TRUE) {
            return true;
        }
        if (this.disabled == Enablement.FALSE) {
            return false;
        }
        return this.isNoTraceAttr(req);
    }

    private boolean isDebug(HttpServletRequest req) {
        Boolean b = this.boolAttr(req, "Debug");
        return b != null && b == true;
    }

    private boolean isNoTraceAttr(HttpServletRequest req) {
        Boolean b = this.boolAttr(req, "NoTrace");
        return b != null && b == true;
    }

    private boolean isNoTraceHeader(HttpServletRequest req) {
        return "true".equalsIgnoreCase(req.getHeader("X-NoTrace"));
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isUseStackTraceHashing() {
        return this.useStackTraceHashing;
    }

    public int getStackTraceHashingTimeout() {
        return this.stackTraceHashingTimeout;
    }

    public List<RestCallLoggerRule> getRules() {
        return Collections.unmodifiableList(Arrays.asList(this.rules));
    }

    private Boolean boolAttr(HttpServletRequest req, String name) {
        Object o = req.getAttribute(name);
        if (o == null || !(o instanceof Boolean)) {
            return null;
        }
        return (Boolean)o;
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT_READABLE.toString((Object)this.toMap());
    }

    public ObjectMap toMap() {
        return new DefaultFilteringObjectMap().append("useStackTraceHashing", (Object)this.useStackTraceHashing).append("disabled", (Object)(this.disabled == Enablement.FALSE ? null : this.disabled)).append("stackTraceHashingTimeout", this.stackTraceHashingTimeout == Integer.MAX_VALUE ? null : Integer.valueOf(this.stackTraceHashingTimeout)).append("level", (Object)(this.level == Level.INFO ? null : this.level)).append("rules", (Object)(this.rules.length == 0 ? null : this.rules));
    }

    public static class Builder {
        List<RestCallLoggerRule> rules = new ArrayList<RestCallLoggerRule>();
        RestCallLoggerConfig parent;
        Level level;
        Boolean useStackTraceHashing;
        Enablement disabled;
        Integer stackTraceHashingTimeout;

        public Builder parent(RestCallLoggerConfig parent) {
            this.parent = parent;
            return this;
        }

        public Builder rule(RestCallLoggerRule rule) {
            this.rules.add(rule);
            return this;
        }

        public Builder rules(RestCallLoggerRule ... rules) {
            for (RestCallLoggerRule rule : rules) {
                this.rules.add(rule);
            }
            return this;
        }

        public Builder disabled(Enablement value) {
            this.disabled = value;
            return this;
        }

        public Builder disabled() {
            return this.disabled(Enablement.TRUE);
        }

        public Builder useStackTraceHashing(Boolean value) {
            this.useStackTraceHashing = value;
            return this;
        }

        public Builder useStackTraceHashing() {
            this.useStackTraceHashing = true;
            return this;
        }

        public Builder stackTraceHashingTimeout(Integer timeout) {
            this.stackTraceHashingTimeout = timeout;
            return this;
        }

        public Builder level(Level value) {
            this.level = value;
            return this;
        }

        public Builder apply(ObjectMap m) {
            for (String key : m.keySet()) {
                if ("useStackTraceHashing".equals(key)) {
                    this.useStackTraceHashing(m.getBoolean("useStackTraceHashing"));
                    continue;
                }
                if ("stackTraceHashingTimeout".equals(key)) {
                    this.stackTraceHashingTimeout(m.getInt("stackTraceHashingTimeout"));
                    continue;
                }
                if ("disabled".equals(key)) {
                    this.disabled((Enablement)((Object)m.get("disabled", Enablement.class)));
                    continue;
                }
                if ("rules".equals(key)) {
                    this.rules((RestCallLoggerRule[])m.get("rules", RestCallLoggerRule[].class));
                    continue;
                }
                if (!"level".equals(key)) continue;
                this.level((Level)m.get("level", Level.class));
            }
            return this;
        }

        public RestCallLoggerConfig build() {
            return new RestCallLoggerConfig(this);
        }
    }
}

