/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationProvider;
import org.apache.juneau.Value;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.MethodInfo;

public final class ParamInfo {
    private final ExecutableInfo eInfo;
    private final Parameter p;
    private final int index;
    private volatile Map<Class<?>, Optional<Annotation>> annotationMap;

    protected ParamInfo(ExecutableInfo eInfo, Parameter p, int index) {
        this.eInfo = eInfo;
        this.p = p;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public MethodInfo getMethod() {
        return this.eInfo.isConstructor() ? null : (MethodInfo)this.eInfo;
    }

    public ConstructorInfo getConstructor() {
        return this.eInfo.isConstructor() ? (ConstructorInfo)this.eInfo : null;
    }

    public ClassInfo getParameterType() {
        return this.eInfo.getParamType(this.index);
    }

    public <A extends Annotation> ParamInfo forEachDeclaredAnnotation(Class<A> type, Predicate<A> filter, Consumer<A> action) {
        for (Annotation a : this.eInfo._getParameterAnnotations(this.index)) {
            ConsumerUtils.consume(type, filter, action, a);
        }
        return this;
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> type) {
        if (type != null) {
            for (Annotation a : this.eInfo._getParameterAnnotations(this.index)) {
                if (!type.isInstance(a)) continue;
                return (A)((Annotation)type.cast(a));
            }
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        Optional<Annotation> o = this.annotationMap().get(type);
        if (o == null) {
            o = CollectionUtils.optional(this.findAnnotation(type));
            this.annotationMap().put(type, o);
        }
        return (A)(o.isPresent() ? o.get() : null);
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.getAnnotation(type) != null;
    }

    public <A extends Annotation> boolean hasNoAnnotation(Class<A> type) {
        return !this.hasAnnotation(type);
    }

    private <A extends Annotation> A findAnnotation(Class<A> type) {
        if (this.eInfo.isConstructor()) {
            for (Annotation a2 : this.eInfo._getParameterAnnotations(this.index)) {
                if (!type.isInstance(a2)) continue;
                return (A)((Annotation)type.cast(a2));
            }
            return this.eInfo.getParamType(this.index).unwrap(Value.class, Optional.class).getAnnotation(type);
        }
        MethodInfo mi = (MethodInfo)this.eInfo;
        Value<Annotation> v = Value.empty();
        mi.forEachMatchingParentFirst(x -> true, x -> x.forEachParameterAnnotation(this.index, type, y -> true, y -> v.set((Annotation)y)));
        return (A)v.orElseGet(() -> this.eInfo.getParamType(this.index).unwrap(Value.class, Optional.class).getAnnotation(type));
    }

    public <A extends Annotation> ParamInfo forEachAnnotation(Class<A> type, Predicate<A> filter, Consumer<A> action) {
        return this.forEachAnnotation(AnnotationProvider.DEFAULT, type, filter, action);
    }

    public <A extends Annotation> A getAnnotation(Class<A> type, Predicate<A> filter) {
        if (this.eInfo.isConstructor) {
            ClassInfo ci = this.eInfo.getParamType(this.index).unwrap(Value.class, Optional.class);
            A o = ci.getAnnotation(type, filter);
            if (o != null) {
                return o;
            }
            for (Annotation a2 : this.eInfo._getParameterAnnotations(this.index)) {
                if (!ConsumerUtils.test(type, filter, a2)) continue;
                return (A)a2;
            }
        } else {
            MethodInfo mi = (MethodInfo)this.eInfo;
            ClassInfo ci = this.eInfo.getParamType(this.index).unwrap(Value.class, Optional.class);
            A o = ci.getAnnotation(type, filter);
            if (o != null) {
                return o;
            }
            Value<Object> v = Value.empty();
            mi.forEachMatchingParentFirst(x -> true, x -> x.forEachParameterAnnotation(this.index, type, filter, y -> v.set(y)));
            return (A)((Annotation)v.orElse(null));
        }
        return null;
    }

    private <A extends Annotation> ParamInfo forEachAnnotation(AnnotationProvider ap, Class<A> a, Predicate<A> filter, Consumer<A> action) {
        if (this.eInfo.isConstructor) {
            ClassInfo ci = this.eInfo.getParamType(this.index).unwrap(Value.class, Optional.class);
            Annotation[] annotations = this.eInfo._getParameterAnnotations(this.index);
            ci.forEachAnnotation(ap, a, filter, action);
            for (Annotation a2 : annotations) {
                ConsumerUtils.consume(a, filter, action, a2);
            }
        } else {
            MethodInfo mi = (MethodInfo)this.eInfo;
            ClassInfo ci = this.eInfo.getParamType(this.index).unwrap(Value.class, Optional.class);
            ci.forEachAnnotation(ap, a, filter, action);
            mi.forEachMatchingParentFirst(x -> true, x -> x.forEachParameterAnnotation(this.index, a, filter, action));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<?>, Optional<Annotation>> annotationMap() {
        if (this.annotationMap == null) {
            ParamInfo paramInfo = this;
            synchronized (paramInfo) {
                this.annotationMap = new ConcurrentHashMap();
            }
        }
        return this.annotationMap;
    }

    public boolean matches(Predicate<ParamInfo> test) {
        return ConsumerUtils.test(test, this);
    }

    public ParamInfo accept(Predicate<ParamInfo> test, Consumer<ParamInfo> action) {
        if (this.matches(test)) {
            action.accept(this);
        }
        return this;
    }

    public boolean isType(Class<?> c) {
        return this.getParameterType().is(c);
    }

    public boolean hasName() {
        return this.p.isNamePresent() || this.p.isAnnotationPresent(Name.class);
    }

    public String getName() {
        Name n = this.p.getAnnotation(Name.class);
        if (n != null) {
            return n.value();
        }
        if (this.p.isNamePresent()) {
            return this.p.getName();
        }
        return null;
    }

    public boolean canAccept(Object value) {
        return this.getParameterType().isInstance(value);
    }

    public String toString() {
        return this.eInfo.getSimpleName() + "[" + this.index + "]";
    }
}

