/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.annotation.BeanAnnotation;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;

public class BeanConfigAnnotation {

    public static class Applier
    extends AnnotationApplier<BeanConfig, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(BeanConfig.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<BeanConfig> ai, BeanContext.Builder b) {
            BeanConfig a = ai.inner();
            this.string(a.beanClassVisibility()).map(Visibility::valueOf).ifPresent(x -> b.beanClassVisibility((Visibility)((Object)x)));
            this.string(a.beanConstructorVisibility()).map(Visibility::valueOf).ifPresent(x -> b.beanConstructorVisibility((Visibility)((Object)x)));
            this.string(a.beanFieldVisibility()).map(Visibility::valueOf).ifPresent(x -> b.beanFieldVisibility((Visibility)((Object)x)));
            this.string(a.beanMethodVisibility()).map(Visibility::valueOf).ifPresent(x -> b.beanMethodVisibility((Visibility)((Object)x)));
            this.bool(a.beanMapPutReturnsOldValue()).ifPresent(x -> b.beanMapPutReturnsOldValue((boolean)x));
            this.bool(a.beansRequireDefaultConstructor()).ifPresent(x -> b.beansRequireDefaultConstructor((boolean)x));
            this.bool(a.beansRequireSerializable()).ifPresent(x -> b.beansRequireSerializable((boolean)x));
            this.bool(a.beansRequireSettersForGetters()).ifPresent(x -> b.beansRequireSettersForGetters((boolean)x));
            this.bool(a.disableBeansRequireSomeProperties()).ifPresent(x -> b.disableBeansRequireSomeProperties((boolean)x));
            this.bool(a.debug()).ifPresent(x -> b.debug((boolean)x));
            this.bool(a.findFluentSetters()).ifPresent(x -> b.findFluentSetters((boolean)x));
            this.bool(a.ignoreInvocationExceptionsOnGetters()).ifPresent(x -> b.ignoreInvocationExceptionsOnGetters((boolean)x));
            this.bool(a.ignoreInvocationExceptionsOnSetters()).ifPresent(x -> b.ignoreInvocationExceptionsOnSetters((boolean)x));
            this.bool(a.disableIgnoreMissingSetters()).ifPresent(x -> b.disableIgnoreMissingSetters((boolean)x));
            this.bool(a.disableIgnoreTransientFields()).ifPresent(x -> b.disableIgnoreTransientFields((boolean)x));
            this.bool(a.ignoreUnknownBeanProperties()).ifPresent(x -> b.ignoreUnknownBeanProperties((boolean)x));
            this.bool(a.ignoreUnknownEnumValues()).ifPresent(x -> b.ignoreUnknownEnumValues((boolean)x));
            this.bool(a.disableIgnoreUnknownNullBeanProperties()).ifPresent(x -> b.disableIgnoreUnknownNullBeanProperties((boolean)x));
            this.bool(a.sortProperties()).ifPresent(x -> b.sortProperties((boolean)x));
            this.bool(a.useEnumNames()).ifPresent(x -> b.useEnumNames((boolean)x));
            this.bool(a.disableInterfaceProxies()).ifPresent(x -> b.disableInterfaceProxies((boolean)x));
            this.bool(a.useJavaBeanIntrospector()).ifPresent(x -> b.useJavaBeanIntrospector((boolean)x));
            this.string(a.typePropertyName()).ifPresent(x -> b.typePropertyName((String)x));
            this.string(a.locale()).map(Locale::forLanguageTag).ifPresent(x -> b.locale((Locale)x));
            this.string(a.mediaType()).map(MediaType::of).ifPresent(x -> b.mediaType((MediaType)x));
            this.string(a.timeZone()).map(TimeZone::getTimeZone).ifPresent(x -> b.timeZone((TimeZone)x));
            this.classes(a.dictionary()).ifPresent(x -> b.beanDictionary((Class<?>)x));
            this.classes(a.dictionary_replace()).ifPresent(x -> {
                b.beanDictionary().clear();
                b.beanDictionary((Class<?>)x);
            });
            this.classes(a.swaps()).ifPresent(x -> b.swaps((Class<?>)x));
            this.classes(a.swaps_replace()).ifPresent(x -> {
                b.swaps().clear();
                b.swaps((Class<?>)x);
            });
            this.classes(a.notBeanClasses()).ifPresent(x -> b.notBeanClasses((Class<?>)x));
            this.classes(a.notBeanClasses_replace()).ifPresent(x -> {
                b.notBeanClasses().clear();
                b.notBeanClasses((Class<?>)x);
            });
            this.type(a.propertyNamer()).ifPresent(x -> b.propertyNamer((Class<? extends PropertyNamer>)x));
            CollectionUtils.l(a.interfaces()).stream().map(x -> BeanAnnotation.create(x).interfaceClass((Class<?>)x).build()).forEach(x -> b.annotations((Annotation)x));
            this.strings(a.notBeanPackages()).ifPresent(x -> b.notBeanPackages((String)x));
            this.strings(a.notBeanPackages_replace()).ifPresent(x -> {
                b.notBeanPackages().clear();
                b.notBeanPackages((String)x);
            });
        }
    }
}

