/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;

public class JsonParserSession
extends ReaderParserSession {
    private static final AsciiSet decChars = AsciiSet.create().ranges("0-9").build();
    private static final AsciiSet VALID_BARE_CHARS = AsciiSet.create().range('A', 'Z').range('a', 'z').range('0', '9').chars("$_-.").build();
    private final JsonParser ctx;

    public static Builder create(JsonParser ctx) {
        return new Builder(ctx);
    }

    protected JsonParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(ClassMeta<?> eType, ParserReader r, Object outer, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        int c;
        if (eType == null) {
            eType = this.object();
        }
        ObjectSwap<Object, ?> swap = eType.getSwap(this);
        BuilderSwap<Object, Object> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = Utils.nn(builder) ? builder.getBuilderClassMeta(this) : (Utils.nn(swap) ? swap.getSwapClassMeta(this) : eType);
        if (sType.isOptional()) {
            return (T)Utils.opt(this.parseAnything(eType.getElementType(), r, outer, pMeta));
        }
        this.setCurrentClass(sType);
        String wrapperAttr = this.getJsonClassMeta(sType).getWrapperAttr();
        Object o = null;
        this.skipCommentsAndSpace(r);
        if (Utils.nn(wrapperAttr)) {
            this.skipWrapperAttrStart(r, wrapperAttr);
        }
        if ((c = r.peek()) == -1) {
            if (this.isStrict()) {
                throw new ParseException((ParserSession)this, "Empty input.", new Object[0]);
            }
        } else if (c == 44 || c == 125 || c == 93) {
            if (this.isStrict()) {
                throw new ParseException((ParserSession)this, "Missing value detected.", new Object[0]);
            }
        } else if (c == 110) {
            this.parseKeyword("null", r);
        } else if (sType.isObject()) {
            if (c == 123) {
                JsonMap jsonMap = new JsonMap(this);
                this.parseIntoMap2(r, jsonMap, this.string(), this.object(), pMeta);
                o = this.cast(jsonMap, pMeta, eType);
            } else if (c == 91) {
                o = this.parseIntoCollection2(r, new JsonList(this), this.object(), pMeta);
            } else if (c == 39 || c == 34) {
                o = this.parseString(r);
                if (sType.isChar()) {
                    o = StringUtils.parseCharacter(o);
                }
            } else if (c >= 48 && c <= 57 || c == 45 || c == 46) {
                o = this.parseNumber(r, null);
            } else if (c == 116) {
                this.parseKeyword("true", r);
                o = Boolean.TRUE;
            } else {
                this.parseKeyword("false", r);
                o = Boolean.FALSE;
            }
        } else if (sType.isBoolean()) {
            o = this.parseBoolean(r);
        } else if (sType.isCharSequence()) {
            o = this.parseString(r);
        } else if (sType.isChar()) {
            o = StringUtils.parseCharacter(this.parseString(r));
        } else if (sType.isNumber()) {
            o = this.parseNumber(r, sType.inner());
        } else if (sType.isMap()) {
            Map map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : this.newGenericMap(sType);
            o = this.parseIntoMap2(r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (c == 123) {
                JsonMap jsonMap = new JsonMap(this);
                this.parseIntoMap2(r, jsonMap, this.string(), this.object(), pMeta);
                o = this.cast(jsonMap, pMeta, eType);
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new JsonList(this);
                o = this.parseIntoCollection2(r, collection, sType, pMeta);
            }
        } else if (Utils.nn(builder)) {
            BeanMap<?> beanMap = this.toBeanMap(builder.create(this, eType));
            o = builder.build(this, this.parseIntoBeanMap2(r, beanMap).getBean(), eType);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap beanMap = this.newBeanMap(outer, sType.inner());
            o = this.parseIntoBeanMap2(r, beanMap).getBean();
        } else if (sType.canCreateNewInstanceFromString(outer) && (c == 39 || c == 34)) {
            o = sType.newInstanceFromString(outer, this.parseString(r));
        } else if (sType.isArray() || sType.isArgs()) {
            if (c == 123) {
                JsonMap jsonMap = new JsonMap(this);
                this.parseIntoMap2(r, jsonMap, this.string(), this.object(), pMeta);
                o = this.cast(jsonMap, pMeta, eType);
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection2(r, CollectionUtils.list(new Object[0]), sType, pMeta);
                o = this.toArray(sType, arrayList);
            }
        } else if (c == 123) {
            JsonMap jsonMap = new JsonMap(this);
            this.parseIntoMap2(r, jsonMap, sType.getKeyType(), sType.getValueType(), pMeta);
            if (jsonMap.containsKey(this.getBeanTypePropertyName(eType))) {
                o = this.cast(jsonMap, pMeta, eType);
            } else {
                if (!Utils.nn(sType.getProxyInvocationHandler())) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", Utils.cn(sType), sType.getNotABeanReason());
                o = this.newBeanMap(outer, sType.inner()).load(jsonMap).getBean();
            }
        } else {
            if (!sType.canCreateNewInstanceFromString(outer) || this.isStrict()) throw new ParseException((ParserSession)this, "Unrecognized syntax for class type ''{0}'', starting character ''{1}''", sType, Character.valueOf((char)c));
            o = sType.newInstanceFromString(outer, this.parseString(r));
        }
        if (Utils.nn(wrapperAttr)) {
            this.skipWrapperAttrEnd(r);
        }
        if (Utils.nn(swap) && Utils.nn(o)) {
            o = this.unswap(swap, o, eType);
        }
        if (!Utils.nn(outer)) return (T)o;
        JsonParserSession.setParent(eType, o, outer);
        return (T)o;
    }

    private Boolean parseBoolean(ParserReader r) throws IOException, ParseException {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return Utils.bool(this.parseString(r));
        }
        if (c == 116) {
            this.parseKeyword("true", r);
            return Boolean.TRUE;
        }
        if (c == 102) {
            this.parseKeyword("false", r);
            return Boolean.FALSE;
        }
        throw new ParseException((ParserSession)this, "Unrecognized syntax.  Expected boolean value, actual=''{0}''", r.read(100));
    }

    private String parseFieldName(ParserReader r) throws IOException, ParseException {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return this.parseString(r);
        }
        if (this.isStrict()) {
            throw new ParseException((ParserSession)this, "Unquoted attribute detected.", new Object[0]);
        }
        if (!VALID_BARE_CHARS.contains(c)) {
            throw new ParseException((ParserSession)this, "Could not find the start of the field name.", new Object[0]);
        }
        r.mark();
        while (c != -1) {
            c = r.read();
            if (VALID_BARE_CHARS.contains(c)) continue;
            r.unread();
            String s = r.getMarked().intern();
            return s.equals("null") ? null : s;
        }
        throw new ParseException((ParserSession)this, "Could not find the end of the field name.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BeanMap<T> parseIntoBeanMap2(ParserReader r, BeanMap<T> m) throws IOException, ParseException, ExecutableException {
        StateEnum state = StateEnum.S1;
        String currAttr = "";
        int c = 0;
        this.mark();
        try {
            while (c != -1) {
                BeanMap<T> beanMap;
                c = r.read();
                if (state == StateEnum.S1) {
                    if (c == 123) {
                        state = StateEnum.S2;
                        continue;
                    }
                    if (!this.isCommentOrWhitespace(c)) break;
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (state == StateEnum.S2) {
                    if (c == 125) {
                        beanMap = m;
                        return beanMap;
                    }
                    if (this.isCommentOrWhitespace(c)) {
                        this.skipCommentsAndSpace(r.unread());
                        continue;
                    }
                    r.unread();
                    this.mark();
                    currAttr = this.parseFieldName(r);
                    state = StateEnum.S3;
                    continue;
                }
                if (state == StateEnum.S3) {
                    if (c != 58) continue;
                    state = StateEnum.S4;
                    continue;
                }
                if (state == StateEnum.S4) {
                    if (this.isCommentOrWhitespace(c)) {
                        this.skipCommentsAndSpace(r.unread());
                        continue;
                    }
                    if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                        BeanPropertyMeta pMeta = m.getPropertyMeta(currAttr);
                        this.setCurrentProperty(pMeta);
                        if (pMeta == null) {
                            this.onUnknownProperty(currAttr, m, this.parseAnything(this.object(), r.unread(), m.getBean(false), null));
                            this.unmark();
                        } else {
                            this.unmark();
                            ClassMeta<?> cm = pMeta.getClassMeta();
                            T value = this.parseAnything(cm, r.unread(), m.getBean(false), pMeta);
                            JsonParserSession.setName(cm, value, currAttr);
                            try {
                                pMeta.set(m, currAttr, value);
                            }
                            catch (BeanRuntimeException e) {
                                this.onBeanSetterException(pMeta, e);
                                throw e;
                            }
                        }
                        this.setCurrentProperty(null);
                    }
                    state = StateEnum.S5;
                    continue;
                }
                if (state != StateEnum.S5) continue;
                if (c == 44) {
                    state = StateEnum.S2;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 125) continue;
                beanMap = m;
                return beanMap;
            }
            if (state == StateEnum.S1) {
                throw new ParseException((ParserSession)this, "Expected '{' at beginning of JSON object.", new Object[0]);
            }
            if (state == StateEnum.S2) {
                throw new ParseException((ParserSession)this, "Could not find attribute name on JSON object.", new Object[0]);
            }
            if (state == StateEnum.S3) {
                throw new ParseException((ParserSession)this, "Could not find ':' following attribute name on JSON object.", new Object[0]);
            }
            if (state == StateEnum.S4) {
                throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
            }
            if (state == StateEnum.S5) {
                throw new ParseException((ParserSession)this, "Could not find '}' marking end of JSON object.", new Object[0]);
            }
        }
        finally {
            this.unmark();
        }
        return null;
    }

    private <E> Collection<E> parseIntoCollection2(ParserReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        int argIndex = 0;
        StateEnum state = StateEnum.S1;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == StateEnum.S1) {
                if (c == 91) {
                    state = StateEnum.S2;
                    continue;
                }
                if (!this.isCommentOrWhitespace(c)) break;
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            if (state == StateEnum.S2) {
                if (c == 93) {
                    return l;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c == -1) continue;
                l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
                state = StateEnum.S3;
                continue;
            }
            if (state == StateEnum.S3) {
                if (c == 44) {
                    state = StateEnum.S4;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 93) break;
                return l;
            }
            if (state != StateEnum.S4) continue;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            if (c == 93) break;
            if (c == -1) continue;
            l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
            state = StateEnum.S3;
        }
        if (state == StateEnum.S1) {
            throw new ParseException((ParserSession)this, "Expected '[' at beginning of JSON array.", new Object[0]);
        }
        if (state == StateEnum.S2) {
            throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == StateEnum.S3) {
            throw new ParseException((ParserSession)this, "Expected ',' or ']'.", new Object[0]);
        }
        if (state == StateEnum.S4) {
            throw new ParseException((ParserSession)this, "Unexpected trailing comma in array.", new Object[0]);
        }
        return null;
    }

    private <K, V> Map<K, V> parseIntoMap2(ParserReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        if (keyType == null) {
            keyType = this.string();
        }
        this.skipCommentsAndSpace(r);
        StateEnum state = StateEnum.S1;
        String currAttr = null;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == StateEnum.S1) {
                if (c != 123) break;
                state = StateEnum.S2;
                continue;
            }
            if (state == StateEnum.S2) {
                if (c == 125) {
                    return m;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                currAttr = this.parseFieldName(r.unread());
                state = StateEnum.S3;
                continue;
            }
            if (state == StateEnum.S3) {
                if (c != 58) continue;
                state = StateEnum.S4;
                continue;
            }
            if (state == StateEnum.S4) {
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                K key = this.convertAttrToType(m, currAttr, keyType);
                Object value = this.parseAnything(valueType, r.unread(), m, pMeta);
                JsonParserSession.setName(valueType, value, key);
                m.put(key, value);
                state = StateEnum.S5;
                continue;
            }
            if (state == StateEnum.S5) {
                if (c == 44) {
                    state = StateEnum.S6;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 125) break;
                return m;
            }
            if (state != StateEnum.S6) continue;
            if (c == 125) break;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            currAttr = this.parseFieldName(r.unread());
            state = StateEnum.S3;
        }
        if (state == StateEnum.S1) {
            throw new ParseException((ParserSession)this, "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == StateEnum.S2) {
            throw new ParseException((ParserSession)this, "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == StateEnum.S3) {
            throw new ParseException((ParserSession)this, "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == StateEnum.S4) {
            throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == StateEnum.S5) {
            throw new ParseException((ParserSession)this, "Could not find '}' marking end of JSON object.", new Object[0]);
        }
        if (state == StateEnum.S6) {
            throw new ParseException((ParserSession)this, "Unexpected '}' found in JSON object.", new Object[0]);
        }
        return null;
    }

    private void parseKeyword(String keyword, ParserReader r) throws IOException, ParseException {
        try {
            String s = r.read(keyword.length());
            if (s.equals(keyword)) {
                return;
            }
            throw new ParseException((ParserSession)this, "Unrecognized syntax.  Expected=''{0}'', Actual=''{1}''", keyword, s);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException((ParserSession)this, "Unrecognized syntax.  Expected=''{0}'', found end-of-file.", keyword);
        }
    }

    private Number parseNumber(ParserReader r, Class<? extends Number> type) throws IOException, ParseException {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return this.parseNumber(r, this.parseString(r), type);
        }
        return this.parseNumber(r, r.parseNumberString(), type);
    }

    private Number parseNumber(ParserReader r, String s, Class<? extends Number> type) throws ParseException {
        if (this.isStrict()) {
            char c2;
            if (s.isEmpty()) {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
            boolean isNegative = false;
            int c = s.charAt(0);
            if (c == 45) {
                isNegative = true;
                int n = c = s.length() == 1 ? 120 : (int)s.charAt(1);
            }
            if (c == 46) {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
            if (c == 48 && s.length() > (isNegative ? 2 : 1) && (c2 = s.charAt(isNegative ? 2 : 1)) != '.' && c2 != 'e' && c2 != 'E') {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
            int i = s.indexOf(46);
            if (!(i == -1 || s.length() != i + 1 && decChars.contains(s.charAt(i + 1)))) {
                throw new ParseException((ParserSession)this, "Invalid JSON number: ''{0}''", s);
            }
        }
        return StringUtils.parseNumber(s, type);
    }

    private String parseString(ParserReader r) throws IOException, ParseException {
        r.mark();
        int qc = r.read();
        if (qc != 34 && this.isStrict()) {
            String msg = qc == 39 ? "Invalid quote character \"{0}\" being used." : "Did not find quote character marking beginning of string.  Character=\"{0}\"";
            throw new ParseException((ParserSession)this, msg, Character.valueOf((char)qc));
        }
        boolean isQuoted = qc == 39 || qc == 34;
        Object s = null;
        boolean isInEscape = false;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (this.isStrict() && c <= 31) {
                throw new ParseException((ParserSession)this, "Unescaped control character encountered: ''0x{0}''", String.format("%04X", c));
            }
            if (isInEscape) {
                switch (c) {
                    case 110: {
                        r.replace('\n');
                        break;
                    }
                    case 114: {
                        r.replace('\r');
                        break;
                    }
                    case 116: {
                        r.replace('\t');
                        break;
                    }
                    case 102: {
                        r.replace('\f');
                        break;
                    }
                    case 98: {
                        r.replace('\b');
                        break;
                    }
                    case 92: {
                        r.replace('\\');
                        break;
                    }
                    case 47: {
                        r.replace('/');
                        break;
                    }
                    case 39: {
                        r.replace('\'');
                        break;
                    }
                    case 34: {
                        r.replace('\"');
                        break;
                    }
                    case 117: {
                        String n = r.read(4);
                        try {
                            r.replace(Integer.parseInt(n, 16), 6);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException((ParserSession)this, "Invalid Unicode escape sequence in string.", new Object[0]);
                        }
                    }
                    default: {
                        throw new ParseException((ParserSession)this, "Invalid escape sequence in string.", new Object[0]);
                    }
                }
                isInEscape = false;
                continue;
            }
            if (c == 92) {
                isInEscape = true;
                r.delete();
                continue;
            }
            if (isQuoted) {
                if (c != qc) continue;
                s = r.getMarked(1, -1);
                break;
            }
            if (c == 44 || c == 125 || c == 93 || this.isWhitespace(c)) {
                s = r.getMarked(0, -1);
                r.unread();
                break;
            }
            if (c != -1) continue;
            s = r.getMarked(0, 0);
            break;
        }
        if (s == null) {
            throw new ParseException((ParserSession)this, "Could not find expected end character ''{0}''.", Character.valueOf((char)qc));
        }
        this.skipCommentsAndSpace(r);
        if (r.peek() == 43) {
            if (this.isStrict()) {
                throw new ParseException((ParserSession)this, "String concatenation detected.", new Object[0]);
            }
            r.read();
            this.skipCommentsAndSpace(r);
            s = (String)s + this.parseString(r);
        }
        return this.trim((String)s);
    }

    private void skipComments(ParserReader r) throws ParseException, IOException {
        block3: {
            int c;
            block2: {
                c = r.read();
                if (c != 42) break block2;
                while (c != -1) {
                    c = r.read();
                    if (c != 42 || (c = r.read()) != 47) continue;
                    return;
                }
                break block3;
            }
            if (c != 47) break block3;
            while (c != -1) {
                c = r.read();
                if (c != -1 && c != 10) continue;
                return;
            }
        }
        throw new ParseException((ParserSession)this, "Open ended comment.", new Object[0]);
    }

    private void skipCommentsAndSpace(ParserReader r) throws IOException, ParseException {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (this.isWhitespace(c)) continue;
            if (c == 47) {
                if (this.isStrict()) {
                    throw new ParseException((ParserSession)this, "Javascript comment detected.", new Object[0]);
                }
                this.skipComments(r);
                continue;
            }
            r.unread();
            return;
        }
    }

    private void skipWrapperAttrEnd(ParserReader r) throws ParseException, IOException {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (this.isWhitespace(c)) continue;
            if (c == 47) {
                if (this.isStrict()) {
                    throw new ParseException((ParserSession)this, "Javascript comment detected.", new Object[0]);
                }
                this.skipComments(r);
                continue;
            }
            if (c == 125) {
                return;
            }
            throw new ParseException((ParserSession)this, "Could not find '}' at the end of JSON wrapper object.", new Object[0]);
        }
    }

    private void skipWrapperAttrStart(ParserReader r, String wrapperAttr) throws IOException, ParseException {
        StateEnum state = StateEnum.S1;
        String currAttr = null;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == StateEnum.S1) {
                if (c != 123) continue;
                state = StateEnum.S2;
                continue;
            }
            if (state == StateEnum.S2) {
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                currAttr = this.parseFieldName(r.unread());
                if (!currAttr.equals(wrapperAttr)) {
                    throw new ParseException((ParserSession)this, "Expected to find wrapper attribute ''{0}'' but found attribute ''{1}''", wrapperAttr, currAttr);
                }
                state = StateEnum.S3;
                continue;
            }
            if (state == StateEnum.S3) {
                if (c != 58) continue;
                state = StateEnum.S4;
                continue;
            }
            if (state != StateEnum.S4) continue;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            r.unread();
            return;
        }
        if (state == StateEnum.S1) {
            throw new ParseException((ParserSession)this, "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == StateEnum.S2) {
            throw new ParseException((ParserSession)this, "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == StateEnum.S3) {
            throw new ParseException((ParserSession)this, "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == StateEnum.S4) {
            throw new ParseException((ParserSession)this, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
    }

    private void validateEnd(ParserReader r) throws IOException, ParseException {
        if (!this.isValidateEnd()) {
            return;
        }
        this.skipCommentsAndSpace(r);
        int c = r.read();
        if (c != -1 && c != 59) {
            throw new ParseException((ParserSession)this, "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
        }
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try (ParserReader r = pipe.getParserReader();){
            if (r == null) {
                T t = null;
                return t;
            }
            T o = this.parseAnything(type, r, this.getOuter(), null);
            this.validateEnd(r);
            T t = o;
            return t;
        }
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws IOException, ParseException, ExecutableException {
        try (ParserReader r = pipe.getParserReader();){
            c = this.parseIntoCollection2(r, c, this.getClassMeta(elementType, new Type[0]), null);
            this.validateEnd(r);
            Collection<E> collection = c;
            return collection;
        }
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws IOException, ParseException, ExecutableException {
        try (ParserReader r = pipe.getParserReader();){
            m = this.parseIntoMap2(r, m, this.getClassMeta(keyType, new Type[0]), this.getClassMeta(valueType, new Type[0]), null);
            this.validateEnd(r);
            Map<K, V> map = m;
            return map;
        }
    }

    protected JsonClassMeta getJsonClassMeta(ClassMeta<?> cm) {
        return this.ctx.getJsonClassMeta(cm);
    }

    protected boolean isCommentOrWhitespace(int cp) {
        if (cp == 47) {
            return true;
        }
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    protected boolean isValidateEnd() {
        return this.ctx.isValidateEnd();
    }

    protected boolean isWhitespace(int cp) {
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    public static class Builder
    extends ReaderParserSession.Builder {
        private JsonParser ctx;

        protected Builder(JsonParser ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public JsonParserSession build() {
            return new JsonParserSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }
    }
}

