/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicStringHeader;

public class BasicMediaTypeHeader
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private final MediaType value;
    private final Supplier<MediaType> supplier;

    public static BasicMediaTypeHeader of(String name, MediaType value) {
        return value == null ? null : new BasicMediaTypeHeader(name, value);
    }

    public static BasicMediaTypeHeader of(String name, String value) {
        return value == null ? null : new BasicMediaTypeHeader(name, value);
    }

    public BasicMediaTypeHeader(String name, MediaType value) {
        super(name, Utils.s((Object)value));
        this.value = value;
        this.supplier = null;
    }

    public BasicMediaTypeHeader(String name, String value) {
        super(name, value);
        this.value = BasicMediaTypeHeader.parse(value);
        this.supplier = null;
    }

    public BasicMediaTypeHeader(String name, Supplier<MediaType> value) {
        super(name, (String)null);
        this.value = null;
        this.supplier = value;
    }

    public Optional<MediaType> asMediaType() {
        return Utils.opt((Object)this.value());
    }

    public String getParameter(String name) {
        return this.orElse(MediaType.EMPTY).getParameter(name);
    }

    public List<NameValuePair> getParameters() {
        return this.orElse(MediaType.EMPTY).getParameters();
    }

    public final String getSubType() {
        return this.orElse(MediaType.EMPTY).getSubType();
    }

    public final List<String> getSubTypes() {
        return this.orElse(MediaType.EMPTY).getSubTypes();
    }

    public final String getType() {
        return this.orElse(MediaType.EMPTY).getType();
    }

    @Override
    public String getValue() {
        return Utils.s((Object)this.value());
    }

    public final boolean hasSubType(String value) {
        return this.orElse(MediaType.EMPTY).hasSubType(value);
    }

    public final boolean isMetaSubtype() {
        return this.orElse(MediaType.EMPTY).isMetaSubtype();
    }

    public int match(List<MediaType> mediaTypes) {
        int matchQuant = 0;
        int matchIndex = -1;
        for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType mt = mediaTypes.get(i);
            int matchQuant2 = mt.match(this.orElse(MediaType.EMPTY), true);
            if (matchQuant2 <= matchQuant) continue;
            matchQuant = matchQuant2;
            matchIndex = i;
        }
        return matchIndex;
    }

    public final int match(MediaType o, boolean allowExtraSubTypes) {
        return this.orElse(MediaType.EMPTY).match(o, allowExtraSubTypes);
    }

    public MediaType orElse(MediaType other) {
        MediaType x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public MediaType toMediaType() {
        return this.value();
    }

    private static MediaType parse(String value) {
        int i;
        if (Utils.nn((Object)value) && (i = value.indexOf(44)) != -1) {
            value = value.substring(i + 1);
        }
        return MediaType.of((String)value);
    }

    private MediaType value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

