/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.uon.UonReader;

public class RestUtils {
    private static Map<Integer, String> httpMsgs = CollectionUtils.mapb(Integer.class, String.class).unmodifiable().add((Object)100, (Object)"Continue").add((Object)101, (Object)"Switching Protocols").add((Object)102, (Object)"Processing").add((Object)103, (Object)"Early Hints").add((Object)200, (Object)"OK").add((Object)201, (Object)"Created").add((Object)202, (Object)"Accepted").add((Object)203, (Object)"Non-Authoritative Information").add((Object)204, (Object)"No Content").add((Object)205, (Object)"Reset Content").add((Object)206, (Object)"Partial Content").add((Object)300, (Object)"Multiple Choices").add((Object)301, (Object)"Moved Permanently").add((Object)302, (Object)"Temporary Redirect").add((Object)303, (Object)"See Other").add((Object)304, (Object)"Not Modified").add((Object)305, (Object)"Use Proxy").add((Object)307, (Object)"Temporary Redirect").add((Object)400, (Object)"Bad Request").add((Object)401, (Object)"Unauthorized").add((Object)402, (Object)"Payment Required").add((Object)403, (Object)"Forbidden").add((Object)404, (Object)"Not Found").add((Object)405, (Object)"Method Not Allowed").add((Object)406, (Object)"Not Acceptable").add((Object)407, (Object)"Proxy Authentication Required").add((Object)408, (Object)"Request Time-Out").add((Object)409, (Object)"Conflict").add((Object)410, (Object)"Gone").add((Object)411, (Object)"Length Required").add((Object)412, (Object)"Precondition Failed").add((Object)413, (Object)"Request Entity Too Large").add((Object)414, (Object)"Request-URI Too Large").add((Object)415, (Object)"Unsupported Media Type").add((Object)500, (Object)"Internal Server Error").add((Object)501, (Object)"Not Implemented").add((Object)502, (Object)"Bad Gateway").add((Object)503, (Object)"Service Unavailable").add((Object)504, (Object)"Gateway Timeout").add((Object)505, (Object)"HTTP Version Not Supported").build();
    private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

    public static String fixMethodPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals("/")) {
            return path;
        }
        return StringUtils.trimTrailingSlashes((String)path);
    }

    public static String getHttpResponseText(int rc) {
        return httpMsgs.get(rc);
    }

    public static String getPathInfoUndecoded(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        int l = contextPath.length() + servletPath.length();
        if (requestURI.length() == l) {
            return null;
        }
        return requestURI.substring(l);
    }

    public static boolean isValidContextPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        return value.charAt(value.length() - 1) != '/' && value.charAt(0) == '/';
    }

    public static boolean isValidPathInfo(String value) {
        if (value == null) {
            return true;
        }
        return !value.isEmpty() && value.charAt(0) == '/';
    }

    public static boolean isValidServletPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        return !value.equals("/") && value.charAt(value.length() - 1) != '/' && value.charAt(0) == '/';
    }

    public static Object parseAnything(String s) throws ParseException {
        if (StringUtils.isProbablyJson((String)s)) {
            return JsonParser.DEFAULT.parse(s, Object.class);
        }
        return s;
    }

    public static String[] parseHeader(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            i = s.indexOf(61);
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
        String val = s.substring(i + 1).trim();
        return (String[])CollectionUtils.a((Object[])new String[]{name, val});
    }

    public static String[] parseKeyValuePair(String s) {
        int i = -1;
        for (int j = 0; j < s.length() && i < 0; ++j) {
            char c = s.charAt(j);
            if (c != '=' && c != ':') continue;
            i = j;
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim();
        String val = s.substring(i + 1).trim();
        return (String[])CollectionUtils.a((Object[])new String[]{name, val});
    }

    public static Map<String, String[]> parseQuery(Object qs) {
        return RestUtils.parseQuery(qs, null);
    }

    public static Map<String, String[]> parseQuery(Object qs, Map<String, String[]> map) {
        LinkedHashMap linkedHashMap;
        LinkedHashMap m = map;
        if (m == null) {
            m = CollectionUtils.map();
        }
        if (qs == null || qs instanceof CharSequence && StringUtils.isEmpty((String)Utils.s((Object)qs))) {
            return m;
        }
        ParserPipe p = new ParserPipe(qs);
        try {
            try (UonReader r = new UonReader(p, true);){
                int c = r.peekSkipWs();
                if (c == 63) {
                    r.read();
                }
                StateEnum state = StateEnum.S1;
                String currAttr = null;
                while (c != -1) {
                    c = r.read();
                    if (state == StateEnum.S1) {
                        if (c == -1) continue;
                        r.unread();
                        r.mark();
                        state = StateEnum.S2;
                        continue;
                    }
                    if (state == StateEnum.S2) {
                        if (c == -1) {
                            RestUtils.add(m, r.getMarked(), null);
                            continue;
                        }
                        if (c == 1) {
                            m.put(r.getMarked(0, -1), null);
                            state = StateEnum.S1;
                            continue;
                        }
                        if (c != 2) continue;
                        currAttr = r.getMarked(0, -1);
                        state = StateEnum.S3;
                        continue;
                    }
                    if (state == StateEnum.S3) {
                        if (c == -1 || c == 1) {
                            RestUtils.add(m, currAttr, "");
                            state = StateEnum.S1;
                            continue;
                        }
                        if (c == 2) {
                            r.replace('=');
                        }
                        r.unread();
                        r.mark();
                        state = StateEnum.S4;
                        continue;
                    }
                    if (state != StateEnum.S4) continue;
                    if (c == -1) {
                        RestUtils.add(m, currAttr, r.getMarked());
                        continue;
                    }
                    if (c == 1) {
                        RestUtils.add(m, currAttr, r.getMarked(0, -1));
                        state = StateEnum.S1;
                        continue;
                    }
                    if (c != 2) continue;
                    r.replace('=');
                }
            }
            linkedHashMap = m;
        }
        catch (Throwable throwable) {
            try {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ThrowableUtils.toRex((Throwable)e);
            }
        }
        p.close();
        return linkedHashMap;
    }

    public static String toValidContextPath(String s) {
        if (s == null || ((String)s).isEmpty()) {
            return "";
        }
        if (((String)(s = StringUtils.trimTrailingSlashes((String)s))).isEmpty()) {
            return s;
        }
        if (((String)s).charAt(0) != '/') {
            s = "/" + (String)s;
        }
        return s;
    }

    public static String trimContextPath(String contextPath, String path) {
        if (path == null) {
            return null;
        }
        if (path.isEmpty() || path.equals("/") || contextPath.isEmpty() || contextPath.equals("/")) {
            return path;
        }
        String op = path;
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (contextPath.charAt(0) == '/') {
            contextPath = contextPath.substring(1);
        }
        if (path.startsWith(contextPath)) {
            if (path.length() == contextPath.length()) {
                return "/";
            }
            if ((path = path.substring(contextPath.length())).isEmpty() || path.charAt(0) == '/') {
                return path;
            }
        }
        return op;
    }

    public static StringBuffer trimPathInfo(StringBuffer requestURI, String contextPath, String servletPath) {
        if (servletPath.equals("/")) {
            servletPath = "";
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        try {
            int sc = 0;
            for (int i = 0; i < requestURI.length(); ++i) {
                int c = requestURI.charAt(i);
                if (c == 47) {
                    int j;
                    if (++sc != 3) continue;
                    if (servletPath.isEmpty()) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    for (j = 0; j < contextPath.length(); ++j) {
                        if (requestURI.charAt(i) != contextPath.charAt(j)) {
                            throw new Exception("case=1");
                        }
                        ++i;
                    }
                    for (j = 0; j < servletPath.length(); ++j) {
                        if (requestURI.charAt(i) != servletPath.charAt(j)) {
                            throw new Exception("case=2");
                        }
                        ++i;
                    }
                    int n = c = requestURI.length() == i ? 47 : (int)requestURI.charAt(i);
                    if (c == 47 || c == 63) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    throw new Exception("case=3");
                }
                if (c != 63) continue;
                if (sc != 2) {
                    throw new Exception("case=4");
                }
                if (servletPath.isEmpty()) {
                    requestURI.setLength(i);
                    return requestURI;
                }
                throw new Exception("case=5");
            }
            if (servletPath.isEmpty()) {
                return requestURI;
            }
            throw new Exception("case=6");
        }
        catch (Exception e) {
            throw ThrowableUtils.rex((Throwable)e, (String)"Could not find servlet path in request URI.  URI=''{0}'', servletPath=''{1}''", (Object[])new Object[]{requestURI, servletPath});
        }
    }

    public static void validateContextPath(String value) {
        if (!RestUtils.isValidContextPath(value)) {
            throw ThrowableUtils.rex((String)"Value is not a valid context path: [{0}]", (Object[])new Object[]{value});
        }
    }

    public static void validatePathInfo(String value) {
        if (!RestUtils.isValidPathInfo(value)) {
            throw ThrowableUtils.rex((String)"Value is not a valid path-info path: [{0}]", (Object[])new Object[]{value});
        }
    }

    public static void validateServletPath(String value) {
        if (!RestUtils.isValidServletPath(value)) {
            throw ThrowableUtils.rex((String)"Value is not a valid servlet path: [{0}]", (Object[])new Object[]{value});
        }
    }

    private static void add(Map<String, String[]> m, String key, String val) {
        boolean b = m.containsKey(key);
        if (val == null) {
            if (!b) {
                m.put(key, null);
            }
        } else if (b && Utils.nn((Object)m.get(key))) {
            m.put(key, (String[])CollectionUtils.addAll((Object[])m.get(key), (Object[])new String[]{val}));
        } else {
            m.put(key, (String[])CollectionUtils.a((Object[])new String[]{val}));
        }
    }

    static String[] resolveContent(String[] content, String[] parentContent) {
        if (content.length == 0) {
            return parentContent;
        }
        List list = CollectionUtils.list((Object[])new String[0]);
        for (String l : content) {
            if ("INHERIT".equals(l)) {
                CollectionUtils.addAll((List)list, (Object[])parentContent);
                continue;
            }
            if ("NONE".equals(l)) {
                return new String[0];
            }
            list.add(l);
        }
        return (String[])CollectionUtils.array((Collection)list, String.class);
    }

    static String[] resolveLinks(String[] links, String[] parentLinks) {
        if (links.length == 0) {
            return parentLinks;
        }
        List list = CollectionUtils.list((Object[])new String[0]);
        for (String l : links) {
            if ("INHERIT".equals(l)) {
                CollectionUtils.addAll((List)list, (Object[])parentLinks);
                continue;
            }
            if (l.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(l).matches()) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(l);
                lm.matches();
                String key = lm.group(1);
                int index = Math.min(list.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                list.add(index, key.isEmpty() ? remainder : key + ":" + remainder);
                continue;
            }
            list.add(l);
        }
        return (String[])CollectionUtils.array((Collection)list, String.class);
    }

    static String resolveNewlineSeparatedAnnotation(String[] value, String fromParent) {
        if (value.length == 0) {
            return fromParent;
        }
        List l = CollectionUtils.list((Object[])new String[0]);
        for (String v : value) {
            if (!"INHERIT".equals(v)) {
                l.add(v);
                continue;
            }
            if (!Utils.nn((Object)fromParent)) continue;
            l.add(fromParent);
        }
        return StringUtils.join((Collection)l, (char)'\n');
    }
}

