/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.servlet;

import java.util.Locale;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.ui.SwaggerUI;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.jsonschema.annotation.JsonSchemaConfig;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestOp;
import org.apache.juneau.rest.stats.RestContextStats;

@HtmlDocConfig(navlinks={"up: request:/..", "api: servlet:/api", "stats: servlet:/stats"})
@JsonSchemaConfig(addDescriptionsTo="bean,collection,array,map,enum", addExamplesTo="bean,collection,array,map", ignoreTypes="Swagger,org.apache.juneau.bean.html5.*", useBeanDefs="true")
public interface BasicRestOperations {
    @RestOp(method="*", path={"/error"}, summary="Error occurred", description={"An error occurred during handling of the request.  ", "Servlet chains will often automatically redirect to '/error' when any sort of error condition occurs ", "(such as failed authentication) and will set appropriate response parameters ", "(such as an WWW-Authenticate response header)."})
    public void error();

    @RestGet(path={"favicon.ico"}, summary="Favorites icon.", description={"Favorites icon."})
    public HttpResource getFavIcon();

    @RestGet(path={"/htdocs/*"}, summary="Static files", description={"Static file retrieval."})
    public HttpResource getHtdoc(@Path String var1, Locale var2);

    @RestGet(path={"/stats"}, summary="Timing statistics", description={"Timing statistics for method invocations on this resource."})
    @HtmlDocConfig(rank=10, navlinks={"back: servlet:/", "json: servlet:/stats?Accept=text/json&plainText=true"}, aside={"NONE"})
    public RestContextStats getStats(RestRequest var1);

    @RestGet(path={"/api/*"}, summary="Swagger documentation", description={"Swagger documentation for this resource."})
    @HtmlDocConfig(rank=10, navlinks={"back: servlet:/", "json: servlet:/?Accept=text/json&plainText=true"}, aside={"NONE"})
    @BeanConfig(swaps={SwaggerUI.class})
    public Swagger getSwagger(RestRequest var1);
}

