/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.uon.UonParserSession;
import org.apache.juneau.uon.UonReader;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingParser;

public class UrlEncodingParserSession
extends UonParserSession {
    private final UrlEncodingParser ctx;

    public static Builder create(UrlEncodingParser ctx) {
        return new Builder(ctx);
    }

    public UrlEncodingParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    public final boolean shouldUseExpandedParams(BeanPropertyMeta pMeta) {
        ClassMeta<?> cm = pMeta.getClassMeta().getSerializedClassMeta(this);
        return cm.isCollectionOrArray() && (this.isExpandedParams() || this.getUrlEncodingClassMeta(pMeta.getBeanMeta().getClassMeta()).isExpandedParams());
    }

    private <T> T parseAnything(ClassMeta<T> eType, UonReader r, Object outer) throws IOException, ParseException, ExecutableException {
        Object o;
        if (eType == null) {
            eType = this.object();
        }
        ObjectSwap<T, ?> swap = eType.getSwap(this);
        BuilderSwap<Object, Object> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = Utils.nn(builder) ? builder.getBuilderClassMeta(this) : (Utils.nn(swap) ? swap.getSwapClassMeta(this) : eType);
        if (sType.isOptional()) {
            return (T)Utils.opt(this.parseAnything(eType.getElementType(), r, outer));
        }
        int c = r.peekSkipWs();
        if (c == 63) {
            r.read();
        }
        if (sType.isObject()) {
            JsonMap m = new JsonMap(this);
            this.parseIntoMap2(r, m, this.getClassMeta((Type)((Object)Map.class), new Type[]{String.class, Object.class}), outer);
            o = m.containsKey("_value") ? m.get("_value") : this.cast(m, null, eType);
        } else if (sType.isMap()) {
            Map m = sType.canCreateNewInstance() ? (Map)sType.newInstance() : this.newGenericMap(sType);
            o = this.parseIntoMap2(r, m, sType, m);
        } else if (Utils.nn(builder)) {
            BeanMap<?> m = this.toBeanMap(builder.create(this, eType));
            o = (m = this.parseIntoBeanMap(r, m)) == null ? null : builder.build(this, m.getBean(), eType);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap m = this.newBeanMap(outer, sType.inner());
            o = (m = this.parseIntoBeanMap(r, m)) == null ? null : m.getBean();
        } else if (sType.isCollection() || sType.isArray() || sType.isArgs()) {
            JsonList c2 = sType.isArray() || sType.isArgs() || !sType.canCreateNewInstance(outer) ? new JsonList(this) : (Collection)sType.newInstance();
            TreeMap m = new TreeMap();
            this.parseIntoMap2(r, m, sType, c2);
            c2.addAll(m.values());
            o = sType.isArgs() ? c2.toArray(new Object[c2.size()]) : (sType.isArray() ? CollectionUtils.toArray(c2, sType.getElementType().inner()) : c2);
        } else {
            JsonMap m = new JsonMap(this);
            this.parseIntoMap2(r, m, this.getClassMeta((Type)((Object)Map.class), new Type[]{String.class, Object.class}), outer);
            if (m.containsKey(this.getBeanTypePropertyName(eType))) {
                o = this.cast(m, null, eType);
            } else if (m.containsKey("_value")) {
                o = this.convertToType(m.get("_value"), sType);
            } else if (Utils.nn(sType.getProxyInvocationHandler())) {
                o = this.newBeanMap(outer, sType.inner()).load(m).getBean();
            } else {
                if (Utils.nn(sType.getNotABeanReason())) {
                    throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated as application/x-www-form-urlencoded.  Reason: ''{1}''", sType, sType.getNotABeanReason());
                }
                throw new ParseException((ParserSession)this, "Malformed application/x-www-form-urlencoded input for class ''{0}''.", sType);
            }
        }
        if (Utils.nn(swap) && Utils.nn(o)) {
            o = this.unswap(swap, o, eType);
        }
        if (Utils.nn(outer)) {
            UrlEncodingParserSession.setParent(eType, o, outer);
        }
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BeanMap<T> parseIntoBeanMap(UonReader r, BeanMap<T> m) throws IOException, ParseException, ExecutableException {
        int c = r.peekSkipWs();
        if (c == -1) {
            return m;
        }
        boolean isInEscape = false;
        StateEnum state = StateEnum.S1;
        String currAttr = "";
        this.mark();
        try {
            while (c != -1) {
                c = r.read();
                if (!isInEscape) {
                    if (state == StateEnum.S1) {
                        if (c == -1) {
                            var7_7 = m;
                            return var7_7;
                        }
                        r.unread();
                        this.mark();
                        currAttr = this.parseAttrName(r, true);
                        if (currAttr == null) {
                            var7_7 = null;
                            return var7_7;
                        }
                        state = StateEnum.S2;
                    } else if (state == StateEnum.S2) {
                        if (c == 2) {
                            state = StateEnum.S3;
                        } else if (c == -1 || c == 1) {
                            m.put(currAttr, (Object)null);
                            if (c == -1) {
                                var7_7 = m;
                                return var7_7;
                            }
                            state = StateEnum.S1;
                        }
                    } else if (state == StateEnum.S3) {
                        if (c == -1 || c == 1) {
                            if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                                pMeta = m.getPropertyMeta(currAttr);
                                if (pMeta == null) {
                                    this.onUnknownProperty(currAttr, m, null);
                                    this.unmark();
                                } else {
                                    this.unmark();
                                    this.setCurrentProperty((BeanPropertyMeta)pMeta);
                                    cm = ((BeanPropertyMeta)pMeta).getClassMeta();
                                    if (cm.canCreateNewInstance()) {
                                        try {
                                            ((BeanPropertyMeta)pMeta).set(m, currAttr, cm.newInstance());
                                        }
                                        catch (BeanRuntimeException e) {
                                            this.onBeanSetterException((BeanPropertyMeta)pMeta, e);
                                            throw e;
                                        }
                                    }
                                    this.setCurrentProperty(null);
                                }
                            }
                            if (c == -1) {
                                pMeta = m;
                                return pMeta;
                            }
                            state = StateEnum.S1;
                        } else {
                            if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                                pMeta = m.getPropertyMeta(currAttr);
                                if (pMeta == null) {
                                    this.onUnknownProperty(currAttr, m, this.parseAnything(this.object(), r.unread(), m.getBean(false), true, null));
                                    this.unmark();
                                } else {
                                    Object value;
                                    this.unmark();
                                    this.setCurrentProperty((BeanPropertyMeta)pMeta);
                                    if (this.shouldUseExpandedParams((BeanPropertyMeta)pMeta)) {
                                        ClassMeta<?> et = ((BeanPropertyMeta)pMeta).getClassMeta().getElementType();
                                        value = this.parseAnything(et, r.unread(), m.getBean(false), true, (BeanPropertyMeta)pMeta);
                                        UrlEncodingParserSession.setName(et, value, currAttr);
                                        try {
                                            ((BeanPropertyMeta)pMeta).add(m, currAttr, value);
                                        }
                                        catch (BeanRuntimeException e) {
                                            this.onBeanSetterException((BeanPropertyMeta)pMeta, e);
                                            throw e;
                                        }
                                    }
                                    cm = ((BeanPropertyMeta)pMeta).getClassMeta();
                                    value = this.parseAnything(cm, r.unread(), m.getBean(false), true, (BeanPropertyMeta)pMeta);
                                    UrlEncodingParserSession.setName(cm, value, currAttr);
                                    try {
                                        ((BeanPropertyMeta)pMeta).set(m, currAttr, value);
                                    }
                                    catch (BeanRuntimeException e) {
                                        this.onBeanSetterException((BeanPropertyMeta)pMeta, e);
                                        throw e;
                                    }
                                    this.setCurrentProperty(null);
                                }
                            }
                            state = StateEnum.S4;
                        }
                    } else if (state == StateEnum.S4) {
                        if (c == 1) {
                            state = StateEnum.S1;
                        } else if (c == -1) {
                            var7_7 = m;
                            return var7_7;
                        }
                    }
                }
                isInEscape = c == 92 && !isInEscape;
            }
            if (state == StateEnum.S1) {
                throw new ParseException((ParserSession)this, "Could not find attribute name on object.", new Object[0]);
            }
            if (state == StateEnum.S2) {
                throw new ParseException((ParserSession)this, "Could not find '=' following attribute name on object.", new Object[0]);
            }
            if (state == StateEnum.S3) {
                throw new ParseException((ParserSession)this, "Could not find value following '=' on object.", new Object[0]);
            }
            if (state == StateEnum.S4) {
                throw new ParseException((ParserSession)this, "Could not find end of object.", new Object[0]);
            }
        }
        finally {
            this.unmark();
        }
        return null;
    }

    private <K, V> Map<K, V> parseIntoMap2(UonReader r, Map<K, V> m, ClassMeta<?> type, Object outer) throws IOException, ParseException, ExecutableException {
        ClassMeta<Integer> keyType = type.isArgs() || type.isCollectionOrArray() ? this.getClassMeta(Integer.class) : type.getKeyType();
        int c = r.peekSkipWs();
        if (c == -1) {
            return m;
        }
        boolean isInEscape = false;
        StateEnum state = StateEnum.S1;
        int argIndex = 0;
        Integer currAttr = null;
        while (c != -1) {
            c = r.read();
            if (!isInEscape) {
                if (state == StateEnum.S1) {
                    if (c == -1) {
                        return m;
                    }
                    r.unread();
                    Object attr = this.parseAttr(r, true);
                    currAttr = attr == null ? null : this.convertAttrToType(m, this.trim(attr.toString()), keyType);
                    state = StateEnum.S2;
                    c = 0;
                } else if (state == StateEnum.S2) {
                    if (c == 2) {
                        state = StateEnum.S3;
                    } else if (c == -1 || c == 1) {
                        m.put(currAttr, null);
                        if (c == -1) {
                            return m;
                        }
                        state = StateEnum.S1;
                    }
                } else if (state == StateEnum.S3) {
                    if (c == -1 || c == 1) {
                        valueType = type.isArgs() ? type.getArg(argIndex++) : (type.isCollectionOrArray() ? type.getElementType() : type.getValueType());
                        value = this.convertAttrToType(m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1) {
                            return m;
                        }
                        state = StateEnum.S1;
                    } else {
                        valueType = type.isArgs() ? type.getArg(argIndex++) : (type.isCollectionOrArray() ? type.getElementType() : type.getValueType());
                        String string = value = valueType.isString() ? super.parseString(r.unread(), true) : super.parseAnything(valueType, r.unread(), outer, true, null);
                        if (m.containsKey(currAttr) && valueType.isObject()) {
                            Object v2 = m.get(currAttr);
                            if (!(v2 instanceof JsonList)) {
                                v2 = new JsonList(v2).setBeanSession(this);
                                m.put(currAttr, v2);
                            }
                            ((JsonList)v2).add(value);
                        } else {
                            m.put(currAttr, value);
                        }
                        state = StateEnum.S4;
                        c = 0;
                    }
                } else if (state == StateEnum.S4) {
                    if (c == 1) {
                        state = StateEnum.S1;
                    } else if (c == -1) {
                        return m;
                    }
                }
            }
            isInEscape = c == 92 && !isInEscape;
        }
        if (state == StateEnum.S1) {
            throw new ParseException((ParserSession)this, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == StateEnum.S2) {
            throw new ParseException((ParserSession)this, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == StateEnum.S3) {
            throw new ParseException((ParserSession)this, "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == StateEnum.S4) {
            throw new ParseException((ParserSession)this, "Could not find end of object.", new Object[0]);
        }
        return null;
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try (UonReader r = UrlEncodingParserSession.getUonReader(pipe, true);){
            T t = this.parseAnything(type, r, this.getOuter());
            return t;
        }
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        try (UonReader r = UrlEncodingParserSession.getUonReader(pipe, true);){
            if (r.peekSkipWs() == 63) {
                r.read();
            }
            Map<K, V> map = m = this.parseIntoMap2(r, m, this.getClassMeta((Type)((Object)Map.class), keyType, valueType), null);
            return map;
        }
    }

    protected UrlEncodingClassMeta getUrlEncodingClassMeta(ClassMeta<?> cm) {
        return this.ctx.getUrlEncodingClassMeta(cm);
    }

    protected final boolean isExpandedParams() {
        return this.ctx.isExpandedParams();
    }

    public static class Builder
    extends UonParserSession.Builder {
        private UrlEncodingParser ctx;

        protected Builder(UrlEncodingParser ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public UrlEncodingParserSession build() {
            return new UrlEncodingParserSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder decoding(boolean value) {
            super.decoding(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }
    }
}

