/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.ProjectArtifactFactory;
import org.apache.maven.lifecycle.internal.SetWithResolutionResult;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LifecycleDependencyResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProjectDependenciesResolver dependenciesResolver;
    private final ProjectArtifactFactory artifactFactory;
    private final EventSpyDispatcher eventSpyDispatcher;
    private final ProjectArtifactsCache projectArtifactsCache;
    private final MessageBuilderFactory messageBuilderFactory;

    @Inject
    public LifecycleDependencyResolver(ProjectDependenciesResolver dependenciesResolver, ProjectArtifactFactory artifactFactory, EventSpyDispatcher eventSpyDispatcher, ProjectArtifactsCache projectArtifactsCache, MessageBuilderFactory messageBuilderFactory) {
        this.dependenciesResolver = dependenciesResolver;
        this.artifactFactory = artifactFactory;
        this.eventSpyDispatcher = eventSpyDispatcher;
        this.projectArtifactsCache = projectArtifactsCache;
        this.messageBuilderFactory = messageBuilderFactory;
    }

    public static List<MavenProject> getProjects(MavenProject project, MavenSession session, boolean aggregator) {
        if (aggregator && project.getCollectedProjects() != null) {
            HashSet<MavenProject> projectAndSubmodules = new HashSet<MavenProject>(project.getCollectedProjects());
            projectAndSubmodules.add(project);
            return session.getProjects().stream().filter(projectAndSubmodules::contains).collect(Collectors.toList());
        }
        return Collections.singletonList(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveProjectDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassRealm projectRealm = project.getClassRealm();
            if (projectRealm != null && projectRealm != tccl) {
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
            }
            if (project.getDependencyArtifacts() == null) {
                try {
                    project.setDependencyArtifacts(this.artifactFactory.createArtifacts(project));
                }
                catch (InvalidDependencyVersionException e) {
                    throw new LifecycleExecutionException(e);
                }
            }
            Set<org.apache.maven.artifact.Artifact> resolvedArtifacts = this.resolveProjectArtifacts(project, scopesToCollect, scopesToResolve, session, aggregating, projectArtifacts);
            HashMap<org.apache.maven.artifact.Artifact, File> reactorProjects = new HashMap<org.apache.maven.artifact.Artifact, File>(session.getProjects().size());
            for (MavenProject reactorProject : session.getProjects()) {
                reactorProjects.put(reactorProject.getArtifact(), reactorProject.getArtifact().getFile());
            }
            HashMap<String, org.apache.maven.artifact.Artifact> map = new HashMap<String, org.apache.maven.artifact.Artifact>();
            for (org.apache.maven.artifact.Artifact artifact : resolvedArtifacts) {
                File reactorProjectFile = (File)reactorProjects.get(artifact);
                if (reactorProjectFile != null) {
                    artifact.setFile(reactorProjectFile);
                }
                map.put(artifact.getDependencyConflictId(), artifact);
            }
            project.setResolvedArtifacts(resolvedArtifacts);
            for (org.apache.maven.artifact.Artifact artifact : project.getDependencyArtifacts()) {
                org.apache.maven.artifact.Artifact resolved;
                if (artifact.getFile() != null || (resolved = (org.apache.maven.artifact.Artifact)map.get(artifact.getDependencyConflictId())) == null) continue;
                artifact.setFile(resolved.getFile());
                artifact.setDependencyTrail(resolved.getDependencyTrail());
                artifact.setResolvedVersion(resolved.getVersion());
                artifact.setResolved(true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public DependencyResolutionResult getProjectDependencyResolutionResult(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        Set<org.apache.maven.artifact.Artifact> resolvedArtifacts = this.resolveProjectArtifacts(project, scopesToCollect, scopesToResolve, session, aggregating, projectArtifacts);
        if (resolvedArtifacts instanceof ProjectArtifactsCache.ArtifactsSetWithResult) {
            ProjectArtifactsCache.ArtifactsSetWithResult artifactsSetWithResult = (ProjectArtifactsCache.ArtifactsSetWithResult)resolvedArtifacts;
            return artifactsSetWithResult.getResult();
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<org.apache.maven.artifact.Artifact> resolveProjectArtifacts(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        ProjectArtifactsCache.Key cacheKey = this.projectArtifactsCache.createKey(project, scopesToCollect, scopesToResolve, aggregating, session.getRepositorySession());
        ProjectArtifactsCache.CacheRecord recordArtifacts = this.projectArtifactsCache.get(cacheKey);
        if (recordArtifacts == null) {
            ProjectArtifactsCache.Key key = cacheKey;
            synchronized (key) {
                recordArtifacts = this.projectArtifactsCache.get(cacheKey);
                if (recordArtifacts == null) {
                    try {
                        Set<org.apache.maven.artifact.Artifact> resolvedArtifacts = this.getDependencies(project, scopesToCollect, scopesToResolve, session, aggregating, projectArtifacts);
                        recordArtifacts = this.projectArtifactsCache.put(cacheKey, resolvedArtifacts);
                    }
                    catch (LifecycleExecutionException e) {
                        this.projectArtifactsCache.put(cacheKey, e);
                        this.projectArtifactsCache.register(project, cacheKey, recordArtifacts);
                        throw e;
                    }
                }
            }
        }
        this.projectArtifactsCache.register(project, cacheKey, recordArtifacts);
        return recordArtifacts.getArtifacts();
    }

    private Set<org.apache.maven.artifact.Artifact> getDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        DependencyResolutionResult result;
        if (scopesToCollect == null) {
            scopesToCollect = Collections.emptySet();
        }
        if (scopesToResolve == null) {
            scopesToResolve = Collections.emptySet();
        }
        if (scopesToCollect.isEmpty() && scopesToResolve.isEmpty()) {
            return new SetWithResolutionResult(null, new LinkedHashSet<org.apache.maven.artifact.Artifact>());
        }
        scopesToCollect = new HashSet<String>(scopesToCollect);
        scopesToCollect.addAll(scopesToResolve);
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(null, this.negate(scopesToCollect));
        ScopeDependencyFilter resolutionFilter = new ScopeDependencyFilter(null, this.negate(scopesToResolve));
        resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)collectionFilter, (DependencyFilter)resolutionFilter);
        resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)resolutionFilter, (DependencyFilter)new ReactorDependencyFilter(projectArtifacts));
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, session.getRepositorySession());
            request.setResolutionFilter((DependencyFilter)resolutionFilter);
            this.eventSpyDispatcher.onEvent(request);
            result = this.dependenciesResolver.resolve(request);
        }
        catch (DependencyResolutionException e) {
            result = e.getResult();
            if (aggregating && this.areAllDependenciesInReactor(session.getProjects(), result.getUnresolvedDependencies())) {
                this.logger.warn("The following dependencies could not be resolved at this point of the build but seem to be part of the reactor:");
                for (Dependency dependency : result.getUnresolvedDependencies()) {
                    this.logger.warn("o {}", (Object)dependency);
                }
                this.logger.warn("Try running the build up to the lifecycle phase \"package\"");
            }
            throw new LifecycleExecutionException(this.messageBuilderFactory, null, project, (Throwable)e);
        }
        this.eventSpyDispatcher.onEvent(result);
        LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
            RepositoryUtils.toArtifacts(artifacts, result.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), (DependencyFilter)collectionFilter);
        }
        return new SetWithResolutionResult(result, artifacts);
    }

    private boolean areAllDependenciesInReactor(Collection<MavenProject> projects, Collection<Dependency> dependencies) {
        Set<String> projectKeys = this.getReactorProjectKeys(projects);
        for (Dependency dependency : dependencies) {
            Artifact a = dependency.getArtifact();
            String key = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion());
            if (projectKeys.contains(key)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getReactorProjectKeys(Collection<MavenProject> projects) {
        HashSet<String> projectKeys = new HashSet<String>(projects.size() * 2);
        for (MavenProject project : projects) {
            String key = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }

    private Collection<String> negate(Collection<String> scopes) {
        HashSet<String> result = new HashSet<String>();
        Collections.addAll(result, "system", "compile", "provided", "runtime", "test");
        for (String scope : scopes) {
            if ("compile".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                continue;
            }
            if ("runtime".equals(scope)) {
                result.remove("compile");
                result.remove("runtime");
                continue;
            }
            if ("compile+runtime".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                result.remove("runtime");
                continue;
            }
            if ("runtime+system".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("runtime");
                continue;
            }
            if (!"test".equals(scope)) continue;
            result.clear();
        }
        return result;
    }

    private static class ReactorDependencyFilter
    implements DependencyFilter {
        private final Set<String> keys = new HashSet<String>();

        ReactorDependencyFilter(Collection<org.apache.maven.artifact.Artifact> artifacts) {
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                String key = ArtifactUtils.key((org.apache.maven.artifact.Artifact)artifact);
                this.keys.add(key);
            }
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            Dependency dependency = node.getDependency();
            if (dependency != null) {
                Artifact a = dependency.getArtifact();
                String key = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion());
                return !this.keys.contains(key);
            }
            return false;
        }
    }
}

