/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;

@Singleton
@Named
public final class DefaultSyncContextFactory
implements SyncContextFactory {
    private static final String ADAPTER_KEY = DefaultSyncContextFactory.class.getName() + ".adapter";
    private final NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory;

    @Inject
    public DefaultSyncContextFactory(NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory) {
        this.namedLockFactoryAdapterFactory = Objects.requireNonNull(namedLockFactoryAdapterFactory);
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        Objects.requireNonNull(session, "session cannot be null");
        NamedLockFactoryAdapter adapter = (NamedLockFactoryAdapter)session.getData().computeIfAbsent((Object)ADAPTER_KEY, () -> this.namedLockFactoryAdapterFactory.getAdapter(session));
        return adapter.newInstance(session, shared);
    }
}

