/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

@Named(value="flat")
@Singleton
@Deprecated
public class FlatRepositoryLayout
implements ArtifactRepositoryLayout {
    private static final char ARTIFACT_SEPARATOR = '-';
    private static final char GROUP_SEPARATOR = '.';

    public String getId() {
        return "flat";
    }

    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && !artifactHandler.getExtension().isEmpty()) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.pathOfRepositoryMetadata(metadata.getLocalFilename(repository));
    }

    private String pathOfRepositoryMetadata(String filename) {
        StringBuilder path = new StringBuilder(128);
        path.append(filename);
        return path.toString();
    }

    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        return this.pathOfRepositoryMetadata(metadata.getRemoteFilename());
    }

    public String toString() {
        return this.getId();
    }
}

