/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import org.apache.maven.lifecycle.internal.PhaseId;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

public class PhaseRecorder {
    private String lastLifecyclePhase;
    private final MavenProject project;

    public PhaseRecorder(MavenProject project) {
        this.project = project;
    }

    public void observeExecution(MojoExecution mojoExecution) {
        String lifecyclePhase = mojoExecution.getLifecyclePhase();
        if (lifecyclePhase != null) {
            PhaseId phaseId = PhaseId.of(lifecyclePhase);
            if (this.lastLifecyclePhase == null) {
                this.lastLifecyclePhase = phaseId.phase();
            } else if (!phaseId.phase().equals(this.lastLifecyclePhase)) {
                this.project.addLifecyclePhase(this.lastLifecyclePhase);
                this.lastLifecyclePhase = phaseId.phase();
            }
        }
        if (this.lastLifecyclePhase != null) {
            this.project.addLifecyclePhase(this.lastLifecyclePhase);
        }
    }

    public boolean isDifferentPhase(MojoExecution nextMojoExecution) {
        String lifecyclePhase = nextMojoExecution.getLifecyclePhase();
        if (lifecyclePhase == null) {
            return this.lastLifecyclePhase != null;
        }
        return !PhaseId.of(lifecyclePhase).phase().equals(this.lastLifecyclePhase);
    }
}

