/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.properties;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRegistryPropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(NiFiRegistryPropertiesLoader.class);

    public NiFiRegistryProperties load(File file) {
        NiFiRegistryProperties niFiRegistryProperties;
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("NiFi Registry properties file missing or unreadable");
        }
        Properties rawProperties = new Properties();
        FileReader reader = new FileReader(file);
        try {
            rawProperties.load(reader);
            NiFiRegistryProperties innerProperties = new NiFiRegistryProperties(rawProperties);
            logger.info("Loaded {} properties from {}", (Object)rawProperties.size(), (Object)file.getAbsolutePath());
            niFiRegistryProperties = innerProperties;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to load Application Properties", ioe);
            }
        }
        reader.close();
        return niFiRegistryProperties;
    }

    public NiFiRegistryProperties load(String path) {
        if (path != null && !path.isBlank()) {
            return this.load(new File(path));
        }
        logger.error("Cannot read from '{}' -- path is null or empty", (Object)path);
        throw new IllegalArgumentException("NiFi Registry properties file path empty or null");
    }
}

