/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.params.AbstractUpdateParamContextCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ParamContextClient;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;

public class RemoveInheritedParamContexts
extends AbstractUpdateParamContextCommand<VoidResult> {
    public RemoveInheritedParamContexts() {
        super("remove-inherited-param-contexts", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Removes all inherited parameter contexts from the given parameter context";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        int updateTimeout = this.getUpdateTimeout(properties);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity existingParameterContextEntity = paramContextClient.getParamContext(paramContextId, false);
        ParameterContextDTO parameterContextDTO = new ParameterContextDTO();
        parameterContextDTO.setId(existingParameterContextEntity.getId());
        parameterContextDTO.setParameters(existingParameterContextEntity.getComponent().getParameters());
        parameterContextDTO.getParameters().stream().filter(t -> t.getParameter().getSensitive()).forEach(t -> t.getParameter().setValue(null));
        ParameterContextEntity updatedParameterContextEntity = new ParameterContextEntity();
        updatedParameterContextEntity.setId(paramContextId);
        updatedParameterContextEntity.setComponent(parameterContextDTO);
        updatedParameterContextEntity.setRevision(existingParameterContextEntity.getRevision());
        ArrayList referenceEntities = new ArrayList();
        parameterContextDTO.setInheritedParameterContexts(referenceEntities);
        ParameterContextUpdateRequestEntity updateRequestEntity = paramContextClient.updateParamContext(updatedParameterContextEntity);
        this.performUpdate(paramContextClient, updatedParameterContextEntity, updateRequestEntity, updateTimeout);
        if (this.isInteractive()) {
            this.println();
        }
        return VoidResult.getInstance();
    }
}

