/*
 * Decompiled with CFR 0.152.
 */
package com.martinkl.warc.mapreduce;

import com.martinkl.warc.WARCFileReader;
import com.martinkl.warc.WARCRecord;
import com.martinkl.warc.WARCWritable;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class WARCInputFormat
extends FileInputFormat<LongWritable, WARCWritable> {
    public RecordReader<LongWritable, WARCWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new WARCReader();
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    private static class WARCReader
    extends RecordReader<LongWritable, WARCWritable> {
        private final LongWritable key = new LongWritable();
        private final WARCWritable value = new WARCWritable();
        private WARCFileReader reader;

        private WARCReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.reader = new WARCFileReader(context.getConfiguration(), ((FileSplit)split).getPath());
        }

        public boolean nextKeyValue() throws IOException {
            try {
                WARCRecord record = this.reader.read();
                this.key.set(this.reader.getRecordsRead());
                this.value.setRecord(record);
                return true;
            }
            catch (EOFException eof) {
                return false;
            }
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.reader.getProgress();
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        public WARCWritable getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }
    }
}

