/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.AclsDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u4A\u0001D\u0007\u0001)!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b]\u0003A\u0011\t-\t\u000fe\u0003\u0001\u0019!C\u00015\"9a\f\u0001a\u0001\n\u0003y\u0006BB3\u0001A\u0003&1\fC\u0003g\u0001\u0011\u0005s\rC\u0003|\u0001\u0011\u0005CP\u0001\u0007BG2\u0004VO\u00197jg\",'O\u0003\u0002\u000f\u001f\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0011#\u000511/\u001a:wKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001QcG\u0011\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\tar$D\u0001\u001e\u0015\tq\u0012#A\u0003vi&d7/\u0003\u0002!;\t9Aj\\4hS:<\u0007C\u0001\u0012-\u001b\u0005\u0019#B\u0001\u0013&\u0003%\u0001XO\u00197jg\",'O\u0003\u0002'O\u0005)\u0011.\\1hK*\u0011!\u0003\u000b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.G\t\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0002\r9|G-Z%e!\t1\u0002'\u0003\u00022/\t\u0019\u0011J\u001c;\u0002\u0019\u0019\fW\u000f\u001c;IC:$G.\u001a:\u0011\u0005QBT\"A\u001b\u000b\u0005Y:\u0014!\u00024bk2$(B\u0001\t(\u0013\tITG\u0001\u0007GCVdG\u000fS1oI2,'/\u0001\u0005o_\u0012,G+\u001f9f!\ta4I\u0004\u0002>\u0003B\u0011ahF\u0007\u0002\u007f)\u0011\u0001iE\u0001\u0007yI|w\u000e\u001e \n\u0005\t;\u0012A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!AQ\f\u0002\u0015\u0005,H\u000f[8sSj,'\u000fE\u0002\u0017\u0011*K!!S\f\u0003\r=\u0003H/[8o!\tYU*D\u0001M\u0015\t1u'\u0003\u0002O\u0019\nQ\u0011)\u001e;i_JL'0\u001a:\u0002\rqJg.\u001b;?)\u0015\t6\u000bV+W!\t\u0011\u0006!D\u0001\u000e\u0011\u0015qS\u00011\u00010\u0011\u0015\u0011T\u00011\u00014\u0011\u0015QT\u00011\u0001<\u0011\u00151U\u00011\u0001H\u0003\u0011q\u0017-\\3\u0015\u0003m\nAcY8na2,G/\u001a3J]&$\u0018.\u00197M_\u0006$W#A.\u0011\u0005Ya\u0016BA/\u0018\u0005\u001d\u0011un\u001c7fC:\f\u0001dY8na2,G/\u001a3J]&$\u0018.\u00197M_\u0006$w\fJ3r)\t\u00017\r\u0005\u0002\u0017C&\u0011!m\u0006\u0002\u0005+:LG\u000fC\u0004e\u0011\u0005\u0005\t\u0019A.\u0002\u0007a$\u0013'A\u000bd_6\u0004H.\u001a;fI&s\u0017\u000e^5bY2{\u0017\r\u001a\u0011\u0002!=tW*\u001a;bI\u0006$\u0018-\u00169eCR,G\u0003\u00021i]NDQ!\u001b\u0006A\u0002)\fQ\u0001Z3mi\u0006\u0004\"a\u001b7\u000e\u0003\u0015J!!\\\u0013\u0003\u001b5+G/\u00193bi\u0006$U\r\u001c;b\u0011\u0015y'\u00021\u0001q\u0003!qWm^%nC\u001e,\u0007CA6r\u0013\t\u0011XEA\u0007NKR\fG-\u0019;b\u00136\fw-\u001a\u0005\u0006i*\u0001\r!^\u0001\t[\u0006t\u0017NZ3tiB\u0011a/_\u0007\u0002o*\u0011\u00010J\u0001\u0007Y>\fG-\u001a:\n\u0005i<(A\u0004'pC\u0012,'/T1oS\u001a,7\u000f^\u0001\u0006G2|7/\u001a\u000b\u0002A\u0002")
public class AclPublisher
implements Logging,
MetadataPublisher {
    private final int nodeId;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final Option<Authorizer> authorizer;
    private boolean completedInitialLoad;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return new StringBuilder(17).append("AclPublisher ").append(this.nodeType).append(" id=").append(this.nodeId).toString();
    }

    public boolean completedInitialLoad() {
        return this.completedInitialLoad;
    }

    public void completedInitialLoad_$eq(boolean x$1) {
        this.completedInitialLoad = x$1;
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        String deltaName = new StringBuilder(20).append("MetadataDelta up to ").append(newImage.offset()).toString();
        Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable & scala.Serializable)aclsDelta -> {
            AclPublisher.$anonfun$onMetadataUpdate$1(this, manifest, newImage, deltaName, aclsDelta);
            return BoxedUnit.UNIT;
        });
    }

    public void close() {
        Authorizer authorizer;
        Option<Authorizer> option = this.authorizer;
        if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
            ((ClusterMetadataAuthorizer)authorizer).completeInitialLoad((Exception)new TimeoutException());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$1(AclPublisher $this, LoaderManifest manifest$1, MetadataImage newImage$1, String deltaName$1, AclsDelta aclsDelta) {
        Authorizer authorizer;
        Option<Authorizer> option = $this.authorizer;
        if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
            ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
            if (manifest$1.type().equals((Object)LoaderManifestType.SNAPSHOT)) {
                try {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Loading authorizer snapshot at offset ").append(newImage$1.offset()).toString());
                    clusterMetadataAuthorizer.loadSnapshot(newImage$1.acls().acls());
                }
                catch (Throwable t) {
                    $this.faultHandler.handleFault(new StringBuilder(37).append("Error loading ").append("authorizer snapshot in ").append(deltaName$1).toString(), t);
                }
            } else {
                try {
                    aclsDelta.changes().entrySet().forEach(e -> {
                        if (((Optional)e.getValue()).isPresent()) {
                            clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (StandardAcl)((Optional)e.getValue()).get());
                            return;
                        }
                        clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
                    });
                }
                catch (Throwable t) {
                    $this.faultHandler.handleFault(new StringBuilder(36).append("Error loading ").append("authorizer changes in ").append(deltaName$1).toString(), t);
                }
            }
            if (!$this.completedInitialLoad()) {
                $this.completedInitialLoad_$eq(true);
                clusterMetadataAuthorizer.completeInitialLoad();
                return;
            }
            return;
        }
    }

    public AclPublisher(int nodeId, FaultHandler faultHandler, String nodeType, Option<Authorizer> authorizer) {
        this.nodeId = nodeId;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.authorizer = authorizer;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(3).append("[").append(this.name()).append("] ").toString());
        this.completedInitialLoad = false;
    }
}

