/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.nio;

import com.barchart.udt.nio.SocketChannelUDT;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;

public class NioInputStreamUDT
extends InputStream {
    protected final SocketChannelUDT channel;

    protected NioInputStreamUDT(SocketChannelUDT channel) {
        if (channel == null) {
            throw new NullPointerException("channel == null");
        }
        if (!channel.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        byte[] data = new byte[1];
        this.read(data);
        return data[0];
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (len > bytes.length - off) {
            throw new IndexOutOfBoundsException("len > bytes.length - off");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.position(off);
        buffer.limit(off + len);
        int read = this.channel.read(buffer);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long remaining;
        int ret;
        ByteBuffer buffer = ByteBuffer.allocateDirect(32768);
        for (remaining = n; remaining > 0L; remaining -= (long)ret) {
            buffer.limit((int)Math.min(remaining, (long)buffer.capacity()));
            ret = this.channel.read(buffer);
            if (ret <= 0) break;
            buffer.rewind();
        }
        return n - remaining;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

