/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.nio;

import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.nio.RendezvousChannelUDT;
import com.barchart.udt.nio.SelectorUDT;
import com.barchart.udt.nio.ServerSocketChannelUDT;
import com.barchart.udt.nio.SocketChannelUDT;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;

public class SelectorProviderUDT
extends SelectorProvider {
    public static final SelectorProviderUDT DATAGRAM = new SelectorProviderUDT(TypeUDT.DATAGRAM);
    public static final SelectorProviderUDT STREAM = new SelectorProviderUDT(TypeUDT.STREAM);
    private volatile int acceptQueueSize = 256;
    private volatile int maxSelectorSize = 1024;
    private final TypeUDT type;

    public static SelectorProviderUDT from(TypeUDT type) {
        switch (type) {
            case DATAGRAM: {
                return DATAGRAM;
            }
            case STREAM: {
                return STREAM;
            }
        }
        throw new IllegalStateException("wrong type=" + (Object)((Object)type));
    }

    public final TypeUDT type() {
        return this.type;
    }

    protected SelectorProviderUDT(TypeUDT type) {
        this.type = type;
    }

    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public int getMaxSelectorSize() {
        return this.maxSelectorSize;
    }

    @Override
    public DatagramChannel openDatagramChannel() throws IOException {
        throw new UnsupportedOperationException("feature not available");
    }

    @Override
    public Pipe openPipe() throws IOException {
        throw new UnsupportedOperationException("feature not available");
    }

    public RendezvousChannelUDT openRendezvousChannel() throws IOException {
        SocketUDT socketUDT = new SocketUDT(this.type);
        return new RendezvousChannelUDT(this, socketUDT);
    }

    @Override
    public SelectorUDT openSelector() throws IOException {
        return new SelectorUDT(this, this.maxSelectorSize);
    }

    @Override
    public ServerSocketChannelUDT openServerSocketChannel() throws IOException {
        SocketUDT serverSocketUDT = new SocketUDT(this.type);
        return new ServerSocketChannelUDT(this, serverSocketUDT);
    }

    @Override
    public SocketChannelUDT openSocketChannel() throws IOException {
        SocketUDT socketUDT = new SocketUDT(this.type);
        return new SocketChannelUDT(this, socketUDT);
    }

    public void setAcceptQueueSize(int queueSize) {
        this.acceptQueueSize = queueSize;
    }

    public void setMaxSelectorSize(int selectorSize) {
        this.maxSelectorSize = selectorSize;
    }
}

